package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusFluentImpl;
import java.lang.Deprecated;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluentImpl;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class ChannelStatusFluentImpl<A extends ChannelStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ChannelStatusFluent<A> {

    private AddressableBuilder address;
    private java.util.Map<String,String> annotations;
    private KReferenceBuilder channel;
    private List<ConditionBuilder> conditions;
    private KReferenceBuilder deadLetterChannel;
    private Long observedGeneration;
    private List<SubscriberStatusBuilder> subscribers;

    public ChannelStatusFluentImpl() {
    }

    public ChannelStatusFluentImpl(ChannelStatus instance) {
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withChannel(instance.getChannel()); 
        this.withConditions(instance.getConditions()); 
        this.withDeadLetterChannel(instance.getDeadLetterChannel()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSubscribers(instance.getSubscribers()); 
    }

    
/**
 * This method has been deprecated, please use method buildAddress instead.
 * @return The buildable object.
 */
@Deprecated public Addressable getAddress() {
        return this.address!=null?this.address.build():null;
    }

    public Addressable buildAddress() {
        return this.address!=null?this.address.build():null;
    }

    public A withAddress(Addressable address) {
        _visitables.get("address").remove(this.address);
        if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public Boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(String url) {
        return (A)withAddress(new Addressable(url));
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.AddressNested<A> withNewAddress() {
        return new AddressNestedImpl();
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNestedImpl(item);
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.AddressNested<A> editAddress() {
        return withNewAddressLike(getAddress());
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.AddressNested<A> editOrNewAddress() {
        return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item) {
        return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A addToAnnotations(String key,String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(java.util.Map<String,String> map) {
        if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(java.util.Map<String,String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getAnnotations() {
        return this.annotations;
    }

    public <K extends Object,V extends Object>A withAnnotations(java.util.Map<String,String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    
/**
 * This method has been deprecated, please use method buildChannel instead.
 * @return The buildable object.
 */
@Deprecated public KReference getChannel() {
        return this.channel!=null?this.channel.build():null;
    }

    public KReference buildChannel() {
        return this.channel!=null?this.channel.build():null;
    }

    public A withChannel(KReference channel) {
        _visitables.get("channel").remove(this.channel);
        if (channel!=null){ this.channel= new KReferenceBuilder(channel); _visitables.get("channel").add(this.channel);} return (A) this;
    }

    public Boolean hasChannel() {
        return this.channel != null;
    }

    public A withNewChannel(String apiVersion,String kind,String name,String namespace) {
        return (A)withChannel(new KReference(apiVersion, kind, name, namespace));
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ChannelNested<A> withNewChannel() {
        return new ChannelNestedImpl();
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ChannelNested<A> withNewChannelLike(KReference item) {
        return new ChannelNestedImpl(item);
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ChannelNested<A> editChannel() {
        return withNewChannelLike(getChannel());
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ChannelNested<A> editOrNewChannel() {
        return withNewChannelLike(getChannel() != null ? getChannel(): new KReferenceBuilder().build());
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ChannelNested<A> editOrNewChannelLike(KReference item) {
        return withNewChannelLike(getChannel() != null ? getChannel(): item);
    }

    public A addToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(Condition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          ConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions() {
        return build(conditions);
    }

    public List<Condition> buildConditions() {
        return build(conditions);
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    
/**
 * This method has been deprecated, please use method buildDeadLetterChannel instead.
 * @return The buildable object.
 */
@Deprecated public KReference getDeadLetterChannel() {
        return this.deadLetterChannel!=null?this.deadLetterChannel.build():null;
    }

    public KReference buildDeadLetterChannel() {
        return this.deadLetterChannel!=null?this.deadLetterChannel.build():null;
    }

    public A withDeadLetterChannel(KReference deadLetterChannel) {
        _visitables.get("deadLetterChannel").remove(this.deadLetterChannel);
        if (deadLetterChannel!=null){ this.deadLetterChannel= new KReferenceBuilder(deadLetterChannel); _visitables.get("deadLetterChannel").add(this.deadLetterChannel);} return (A) this;
    }

    public Boolean hasDeadLetterChannel() {
        return this.deadLetterChannel != null;
    }

    public A withNewDeadLetterChannel(String apiVersion,String kind,String name,String namespace) {
        return (A)withDeadLetterChannel(new KReference(apiVersion, kind, name, namespace));
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.DeadLetterChannelNested<A> withNewDeadLetterChannel() {
        return new DeadLetterChannelNestedImpl();
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.DeadLetterChannelNested<A> withNewDeadLetterChannelLike(KReference item) {
        return new DeadLetterChannelNestedImpl(item);
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.DeadLetterChannelNested<A> editDeadLetterChannel() {
        return withNewDeadLetterChannelLike(getDeadLetterChannel());
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.DeadLetterChannelNested<A> editOrNewDeadLetterChannel() {
        return withNewDeadLetterChannelLike(getDeadLetterChannel() != null ? getDeadLetterChannel(): new KReferenceBuilder().build());
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.DeadLetterChannelNested<A> editOrNewDeadLetterChannelLike(KReference item) {
        return withNewDeadLetterChannelLike(getDeadLetterChannel() != null ? getDeadLetterChannel(): item);
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A withNewObservedGeneration(long arg1) {
        return (A)withObservedGeneration(new Long(arg1));
    }

    public A addToSubscribers(int index,SubscriberStatus item) {
        if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
        SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").add(index >= 0 ? index : _visitables.get("subscribers").size(), builder);this.subscribers.add(index >= 0 ? index : subscribers.size(), builder); return (A)this;
    }

    public A setToSubscribers(int index,SubscriberStatus item) {
        if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
        SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("subscribers").size()) { _visitables.get("subscribers").add(builder); } else { _visitables.get("subscribers").set(index, builder);}
        if (index < 0 || index >= subscribers.size()) { subscribers.add(builder); } else { subscribers.set(index, builder);}
         return (A)this;
    }

    public A addToSubscribers(SubscriberStatus... items) {
        if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
        for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A addAllToSubscribers(Collection<SubscriberStatus> items) {
        if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
        for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A removeFromSubscribers(SubscriberStatus... items) {
        for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubscribers(Collection<SubscriberStatus> items) {
        for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSubscribers(Predicate<SubscriberStatusBuilder> predicate) {
        if (subscribers == null) return (A) this;
        final Iterator<SubscriberStatusBuilder> each = subscribers.iterator();
        final List visitables = _visitables.get("subscribers");
        while (each.hasNext()) {
          SubscriberStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubscribers instead.
 * @return The buildable object.
 */
@Deprecated public List<SubscriberStatus> getSubscribers() {
        return build(subscribers);
    }

    public List<SubscriberStatus> buildSubscribers() {
        return build(subscribers);
    }

    public SubscriberStatus buildSubscriber(int index) {
        return this.subscribers.get(index).build();
    }

    public SubscriberStatus buildFirstSubscriber() {
        return this.subscribers.get(0).build();
    }

    public SubscriberStatus buildLastSubscriber() {
        return this.subscribers.get(subscribers.size() - 1).build();
    }

    public SubscriberStatus buildMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
        for (SubscriberStatusBuilder item: subscribers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
        for (SubscriberStatusBuilder item: subscribers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSubscribers(List<SubscriberStatus> subscribers) {
        if (this.subscribers != null) { _visitables.get("subscribers").removeAll(this.subscribers);}
        if (subscribers != null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>(); for (SubscriberStatus item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
    }

    public A withSubscribers(SubscriberStatus... subscribers) {
        if (this.subscribers != null) {this.subscribers.clear();}
        if (subscribers != null) {for (SubscriberStatus item :subscribers){ this.addToSubscribers(item);}} return (A) this;
    }

    public Boolean hasSubscribers() {
        return subscribers != null && !subscribers.isEmpty();
    }

    public A addNewSubscriber(String message,Long observedGeneration,String ready,String uid) {
        return (A)addToSubscribers(new SubscriberStatus(message, observedGeneration, ready, uid));
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.SubscribersNested<A> addNewSubscriber() {
        return new SubscribersNestedImpl();
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberStatus item) {
        return new SubscribersNestedImpl(-1, item);
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.SubscribersNested<A> setNewSubscriberLike(int index,SubscriberStatus item) {
        return new SubscribersNestedImpl(index, item);
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.SubscribersNested<A> editSubscriber(int index) {
        if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
        return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.SubscribersNested<A> editFirstSubscriber() {
        if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
        return setNewSubscriberLike(0, buildSubscriber(0));
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.SubscribersNested<A> editLastSubscriber() {
        int index = subscribers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
        return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public io.fabric8.knative.messaging.v1.ChannelStatusFluent.SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<subscribers.size();i++) { 
        if (predicate.test(subscribers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
        return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ChannelStatusFluentImpl that = (ChannelStatusFluentImpl) o;
        if (address != null ? !address.equals(that.address) :that.address != null) return false;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (channel != null ? !channel.equals(that.channel) :that.channel != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (deadLetterChannel != null ? !deadLetterChannel.equals(that.deadLetterChannel) :that.deadLetterChannel != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        if (subscribers != null ? !subscribers.equals(that.subscribers) :that.subscribers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(address,  annotations,  channel,  conditions,  deadLetterChannel,  observedGeneration,  subscribers,  super.hashCode());
    }

    public class AddressNestedImpl<N> extends AddressableFluentImpl<io.fabric8.knative.messaging.v1.ChannelStatusFluent.AddressNested<N>> implements io.fabric8.knative.messaging.v1.ChannelStatusFluent.AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AddressableBuilder builder;

            AddressNestedImpl(Addressable item) {
                this.builder = new AddressableBuilder(this, item);
                        
            }

            AddressNestedImpl() {
                this.builder = new AddressableBuilder(this);
                        
            }

            public N and() {
                return (N) ChannelStatusFluentImpl.this.withAddress(builder.build());
            }

            public N endAddress() {
                return and();
            }
    }


    public class ChannelNestedImpl<N> extends KReferenceFluentImpl<io.fabric8.knative.messaging.v1.ChannelStatusFluent.ChannelNested<N>> implements io.fabric8.knative.messaging.v1.ChannelStatusFluent.ChannelNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KReferenceBuilder builder;

            ChannelNestedImpl(KReference item) {
                this.builder = new KReferenceBuilder(this, item);
                        
            }

            ChannelNestedImpl() {
                this.builder = new KReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ChannelStatusFluentImpl.this.withChannel(builder.build());
            }

            public N endChannel() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<io.fabric8.knative.messaging.v1.ChannelStatusFluent.ConditionsNested<N>> implements io.fabric8.knative.messaging.v1.ChannelStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,Condition item) {
                this.index = index;
                this.builder = new ConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) ChannelStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class DeadLetterChannelNestedImpl<N> extends KReferenceFluentImpl<io.fabric8.knative.messaging.v1.ChannelStatusFluent.DeadLetterChannelNested<N>> implements io.fabric8.knative.messaging.v1.ChannelStatusFluent.DeadLetterChannelNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KReferenceBuilder builder;

            DeadLetterChannelNestedImpl(KReference item) {
                this.builder = new KReferenceBuilder(this, item);
                        
            }

            DeadLetterChannelNestedImpl() {
                this.builder = new KReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ChannelStatusFluentImpl.this.withDeadLetterChannel(builder.build());
            }

            public N endDeadLetterChannel() {
                return and();
            }
    }


    public class SubscribersNestedImpl<N> extends SubscriberStatusFluentImpl<io.fabric8.knative.messaging.v1.ChannelStatusFluent.SubscribersNested<N>> implements io.fabric8.knative.messaging.v1.ChannelStatusFluent.SubscribersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SubscriberStatusBuilder builder;
        private final int index;

            SubscribersNestedImpl(int index,SubscriberStatus item) {
                this.index = index;
                this.builder = new SubscriberStatusBuilder(this, item);
                        
            }

            SubscribersNestedImpl() {
                this.index = -1;
                this.builder = new SubscriberStatusBuilder(this);
                        
            }

            public N and() {
                return (N) ChannelStatusFluentImpl.this.setToSubscribers(index,builder.build());
            }

            public N endSubscriber() {
                return and();
            }
    }


}
