package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ChannelTemplateSpecBuilder extends ChannelTemplateSpecFluentImpl<ChannelTemplateSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ChannelTemplateSpec,ChannelTemplateSpecBuilder> {

    ChannelTemplateSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ChannelTemplateSpecBuilder() {
        this(true);
    }

    public ChannelTemplateSpecBuilder(Boolean validationEnabled) {
        this(new ChannelTemplateSpec(), validationEnabled);
    }

    public ChannelTemplateSpecBuilder(ChannelTemplateSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ChannelTemplateSpecBuilder(ChannelTemplateSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ChannelTemplateSpec(), validationEnabled);
    }

    public ChannelTemplateSpecBuilder(ChannelTemplateSpecFluent<?> fluent,ChannelTemplateSpec instance) {
        this(fluent, instance, true);
    }

    public ChannelTemplateSpecBuilder(ChannelTemplateSpecFluent<?> fluent,ChannelTemplateSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public ChannelTemplateSpecBuilder(ChannelTemplateSpec instance) {
        this(instance,true);
    }

    public ChannelTemplateSpecBuilder(ChannelTemplateSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.messaging.v1.EditableChannelTemplateSpec build() {
        EditableChannelTemplateSpec buildable = new EditableChannelTemplateSpec(fluent.getApiVersion(),fluent.getKind(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ChannelTemplateSpecBuilder that = (ChannelTemplateSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
