package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PingSourceBuilder extends PingSourceFluentImpl<PingSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PingSource,PingSourceBuilder> {

    PingSourceFluent<?> fluent;
    Boolean validationEnabled;

    public PingSourceBuilder() {
        this(true);
    }

    public PingSourceBuilder(Boolean validationEnabled) {
        this(new PingSource(), validationEnabled);
    }

    public PingSourceBuilder(PingSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public PingSourceBuilder(PingSourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PingSource(), validationEnabled);
    }

    public PingSourceBuilder(PingSourceFluent<?> fluent,PingSource instance) {
        this(fluent, instance, true);
    }

    public PingSourceBuilder(PingSourceFluent<?> fluent,PingSource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public PingSourceBuilder(PingSource instance) {
        this(instance,true);
    }

    public PingSourceBuilder(PingSource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.sources.v1beta1.EditablePingSource build() {
        EditablePingSource buildable = new EditablePingSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PingSourceBuilder that = (PingSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
