package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PingSourceListBuilder extends PingSourceListFluentImpl<PingSourceListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PingSourceList,PingSourceListBuilder> {

    PingSourceListFluent<?> fluent;
    Boolean validationEnabled;

    public PingSourceListBuilder() {
        this(true);
    }

    public PingSourceListBuilder(Boolean validationEnabled) {
        this(new PingSourceList(), validationEnabled);
    }

    public PingSourceListBuilder(PingSourceListFluent<?> fluent) {
        this(fluent, true);
    }

    public PingSourceListBuilder(PingSourceListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PingSourceList(), validationEnabled);
    }

    public PingSourceListBuilder(PingSourceListFluent<?> fluent,PingSourceList instance) {
        this(fluent, instance, true);
    }

    public PingSourceListBuilder(PingSourceListFluent<?> fluent,PingSourceList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public PingSourceListBuilder(PingSourceList instance) {
        this(instance,true);
    }

    public PingSourceListBuilder(PingSourceList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.sources.v1beta1.EditablePingSourceList build() {
        EditablePingSourceList buildable = new EditablePingSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PingSourceListBuilder that = (PingSourceListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
