package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class AwsSqsSourceSpecFluentImpl<A extends AwsSqsSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AwsSqsSourceSpecFluent<A> {

    private java.util.Map<String,String> annotations;
    private SecretKeySelector awsCredsSecret;
    private String queueUrl;
    private String serviceAccountName;
    private ObjectReferenceBuilder sink;

    public AwsSqsSourceSpecFluentImpl() {
    }

    public AwsSqsSourceSpecFluentImpl(AwsSqsSourceSpec instance) {
        this.withAnnotations(instance.getAnnotations()); 
        this.withAwsCredsSecret(instance.getAwsCredsSecret()); 
        this.withQueueUrl(instance.getQueueUrl()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSink(instance.getSink()); 
    }

    public A addToAnnotations(String key,String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(java.util.Map<String,String> map) {
        if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(java.util.Map<String,String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getAnnotations() {
        return this.annotations;
    }

    public <K extends Object,V extends Object>A withAnnotations(java.util.Map<String,String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public SecretKeySelector getAwsCredsSecret() {
        return this.awsCredsSecret;
    }

    public A withAwsCredsSecret(SecretKeySelector awsCredsSecret) {
        this.awsCredsSecret=awsCredsSecret; return (A) this;
    }

    public Boolean hasAwsCredsSecret() {
        return this.awsCredsSecret != null;
    }

    public A withNewAwsCredsSecret(String key,String name,Boolean optional) {
        return (A)withAwsCredsSecret(new SecretKeySelector(key, name, optional));
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public A withQueueUrl(String queueUrl) {
        this.queueUrl=queueUrl; return (A) this;
    }

    public Boolean hasQueueUrl() {
        return this.queueUrl != null;
    }

    public A withNewQueueUrl(StringBuilder arg1) {
        return (A)withQueueUrl(new String(arg1));
    }

    public A withNewQueueUrl(int[] arg1,int arg2,int arg3) {
        return (A)withQueueUrl(new String(arg1, arg2, arg3));
    }

    public A withNewQueueUrl(char[] arg1) {
        return (A)withQueueUrl(new String(arg1));
    }

    public A withNewQueueUrl(StringBuffer arg1) {
        return (A)withQueueUrl(new String(arg1));
    }

    public A withNewQueueUrl(byte[] arg1,int arg2) {
        return (A)withQueueUrl(new String(arg1, arg2));
    }

    public A withNewQueueUrl(byte[] arg1) {
        return (A)withQueueUrl(new String(arg1));
    }

    public A withNewQueueUrl(char[] arg1,int arg2,int arg3) {
        return (A)withQueueUrl(new String(arg1, arg2, arg3));
    }

    public A withNewQueueUrl(byte[] arg1,int arg2,int arg3) {
        return (A)withQueueUrl(new String(arg1, arg2, arg3));
    }

    public A withNewQueueUrl(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withQueueUrl(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewQueueUrl(String arg1) {
        return (A)withQueueUrl(new String(arg1));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(int[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(char[] arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2) {
        return (A)withServiceAccountName(new String(arg1, arg2));
    }

    public A withNewServiceAccountName(byte[] arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(char[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public ObjectReference buildSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public A withSink(ObjectReference sink) {
        _visitables.get("sink").remove(this.sink);
        if (sink!=null){ this.sink= new ObjectReferenceBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink() {
        return this.sink != null;
    }

    public io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceSpecFluent.SinkNested<A> withNewSink() {
        return new SinkNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceSpecFluent.SinkNested<A> withNewSinkLike(ObjectReference item) {
        return new SinkNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceSpecFluent.SinkNested<A> editSink() {
        return withNewSinkLike(getSink());
    }

    public io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceSpecFluent.SinkNested<A> editOrNewSink() {
        return withNewSinkLike(getSink() != null ? getSink(): new ObjectReferenceBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceSpecFluent.SinkNested<A> editOrNewSinkLike(ObjectReference item) {
        return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AwsSqsSourceSpecFluentImpl that = (AwsSqsSourceSpecFluentImpl) o;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (awsCredsSecret != null ? !awsCredsSecret.equals(that.awsCredsSecret) :that.awsCredsSecret != null) return false;
        if (queueUrl != null ? !queueUrl.equals(that.queueUrl) :that.queueUrl != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(annotations,  awsCredsSecret,  queueUrl,  serviceAccountName,  sink,  super.hashCode());
    }

    public class SinkNestedImpl<N> extends ObjectReferenceFluentImpl<io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceSpecFluent.SinkNested<N>> implements io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceSpecFluent.SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectReferenceBuilder builder;

            SinkNestedImpl(ObjectReference item) {
                this.builder = new ObjectReferenceBuilder(this, item);
                        
            }

            SinkNestedImpl() {
                this.builder = new ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) AwsSqsSourceSpecFluentImpl.this.withSink(builder.build());
            }

            public N endSink() {
                return and();
            }
    }


}
