package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

public class GitHubSourceSpecFluentImpl<A extends GitHubSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GitHubSourceSpecFluent<A> {

    private SecretValueFromSourceBuilder accessToken;
    private CloudEventOverridesBuilder ceOverrides;
    private List<String> eventTypes;
    private String githubAPIURL;
    private String ownerAndRepository;
    private SecretValueFromSourceBuilder secretToken;
    private Boolean secure;
    private String serviceAccountName;
    private DestinationBuilder sink;

    public GitHubSourceSpecFluentImpl() {
    }

    public GitHubSourceSpecFluentImpl(GitHubSourceSpec instance) {
        this.withAccessToken(instance.getAccessToken()); 
        this.withCeOverrides(instance.getCeOverrides()); 
        this.withEventTypes(instance.getEventTypes()); 
        this.withGithubAPIURL(instance.getGithubAPIURL()); 
        this.withOwnerAndRepository(instance.getOwnerAndRepository()); 
        this.withSecretToken(instance.getSecretToken()); 
        this.withSecure(instance.getSecure()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSink(instance.getSink()); 
    }

    
/**
 * This method has been deprecated, please use method buildAccessToken instead.
 * @return The buildable object.
 */
@Deprecated public SecretValueFromSource getAccessToken() {
        return this.accessToken!=null?this.accessToken.build():null;
    }

    public SecretValueFromSource buildAccessToken() {
        return this.accessToken!=null?this.accessToken.build():null;
    }

    public A withAccessToken(SecretValueFromSource accessToken) {
        _visitables.get("accessToken").remove(this.accessToken);
        if (accessToken!=null){ this.accessToken= new SecretValueFromSourceBuilder(accessToken); _visitables.get("accessToken").add(this.accessToken);} return (A) this;
    }

    public Boolean hasAccessToken() {
        return this.accessToken != null;
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.AccessTokenNested<A> withNewAccessToken() {
        return new AccessTokenNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.AccessTokenNested<A> withNewAccessTokenLike(SecretValueFromSource item) {
        return new AccessTokenNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.AccessTokenNested<A> editAccessToken() {
        return withNewAccessTokenLike(getAccessToken());
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.AccessTokenNested<A> editOrNewAccessToken() {
        return withNewAccessTokenLike(getAccessToken() != null ? getAccessToken(): new SecretValueFromSourceBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.AccessTokenNested<A> editOrNewAccessTokenLike(SecretValueFromSource item) {
        return withNewAccessTokenLike(getAccessToken() != null ? getAccessToken(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCeOverrides instead.
 * @return The buildable object.
 */
@Deprecated public CloudEventOverrides getCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public A withCeOverrides(CloudEventOverrides ceOverrides) {
        _visitables.get("ceOverrides").remove(this.ceOverrides);
        if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} return (A) this;
    }

    public Boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.CeOverridesNested<A> withNewCeOverrides() {
        return new CeOverridesNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
        return new CeOverridesNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.CeOverridesNested<A> editCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides());
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): new CloudEventOverridesBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): item);
    }

    public A addToEventTypes(int index,String item) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        this.eventTypes.add(index, item);
        return (A)this;
    }

    public A setToEventTypes(int index,String item) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        this.eventTypes.set(index, item); return (A)this;
    }

    public A addToEventTypes(String... items) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        for (String item : items) {this.eventTypes.add(item);} return (A)this;
    }

    public A addAllToEventTypes(Collection<String> items) {
        if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
        for (String item : items) {this.eventTypes.add(item);} return (A)this;
    }

    public A removeFromEventTypes(String... items) {
        for (String item : items) {if (this.eventTypes!= null){ this.eventTypes.remove(item);}} return (A)this;
    }

    public A removeAllFromEventTypes(Collection<String> items) {
        for (String item : items) {if (this.eventTypes!= null){ this.eventTypes.remove(item);}} return (A)this;
    }

    public List<String> getEventTypes() {
        return this.eventTypes;
    }

    public String getEventType(int index) {
        return this.eventTypes.get(index);
    }

    public String getFirstEventType() {
        return this.eventTypes.get(0);
    }

    public String getLastEventType() {
        return this.eventTypes.get(eventTypes.size() - 1);
    }

    public String getMatchingEventType(Predicate<String> predicate) {
        for (String item: eventTypes) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEventType(Predicate<String> predicate) {
        for (String item: eventTypes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEventTypes(List<String> eventTypes) {
        if (this.eventTypes != null) { _visitables.get("eventTypes").removeAll(this.eventTypes);}
        if (eventTypes != null) {this.eventTypes = new ArrayList<String>(); for (String item : eventTypes){this.addToEventTypes(item);}} else { this.eventTypes = null;} return (A) this;
    }

    public A withEventTypes(String... eventTypes) {
        if (this.eventTypes != null) {this.eventTypes.clear();}
        if (eventTypes != null) {for (String item :eventTypes){ this.addToEventTypes(item);}} return (A) this;
    }

    public Boolean hasEventTypes() {
        return eventTypes != null && !eventTypes.isEmpty();
    }

    public A addNewEventType(StringBuilder arg1) {
        return (A)addToEventTypes(new String(arg1));
    }

    public A addNewEventType(int[] arg1,int arg2,int arg3) {
        return (A)addToEventTypes(new String(arg1, arg2, arg3));
    }

    public A addNewEventType(char[] arg1) {
        return (A)addToEventTypes(new String(arg1));
    }

    public A addNewEventType(StringBuffer arg1) {
        return (A)addToEventTypes(new String(arg1));
    }

    public A addNewEventType(byte[] arg1,int arg2) {
        return (A)addToEventTypes(new String(arg1, arg2));
    }

    public A addNewEventType(byte[] arg1) {
        return (A)addToEventTypes(new String(arg1));
    }

    public A addNewEventType(char[] arg1,int arg2,int arg3) {
        return (A)addToEventTypes(new String(arg1, arg2, arg3));
    }

    public A addNewEventType(byte[] arg1,int arg2,int arg3) {
        return (A)addToEventTypes(new String(arg1, arg2, arg3));
    }

    public A addNewEventType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToEventTypes(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewEventType(String arg1) {
        return (A)addToEventTypes(new String(arg1));
    }

    public String getGithubAPIURL() {
        return this.githubAPIURL;
    }

    public A withGithubAPIURL(String githubAPIURL) {
        this.githubAPIURL=githubAPIURL; return (A) this;
    }

    public Boolean hasGithubAPIURL() {
        return this.githubAPIURL != null;
    }

    public A withNewGithubAPIURL(StringBuilder arg1) {
        return (A)withGithubAPIURL(new String(arg1));
    }

    public A withNewGithubAPIURL(int[] arg1,int arg2,int arg3) {
        return (A)withGithubAPIURL(new String(arg1, arg2, arg3));
    }

    public A withNewGithubAPIURL(char[] arg1) {
        return (A)withGithubAPIURL(new String(arg1));
    }

    public A withNewGithubAPIURL(StringBuffer arg1) {
        return (A)withGithubAPIURL(new String(arg1));
    }

    public A withNewGithubAPIURL(byte[] arg1,int arg2) {
        return (A)withGithubAPIURL(new String(arg1, arg2));
    }

    public A withNewGithubAPIURL(byte[] arg1) {
        return (A)withGithubAPIURL(new String(arg1));
    }

    public A withNewGithubAPIURL(char[] arg1,int arg2,int arg3) {
        return (A)withGithubAPIURL(new String(arg1, arg2, arg3));
    }

    public A withNewGithubAPIURL(byte[] arg1,int arg2,int arg3) {
        return (A)withGithubAPIURL(new String(arg1, arg2, arg3));
    }

    public A withNewGithubAPIURL(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withGithubAPIURL(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewGithubAPIURL(String arg1) {
        return (A)withGithubAPIURL(new String(arg1));
    }

    public String getOwnerAndRepository() {
        return this.ownerAndRepository;
    }

    public A withOwnerAndRepository(String ownerAndRepository) {
        this.ownerAndRepository=ownerAndRepository; return (A) this;
    }

    public Boolean hasOwnerAndRepository() {
        return this.ownerAndRepository != null;
    }

    public A withNewOwnerAndRepository(StringBuilder arg1) {
        return (A)withOwnerAndRepository(new String(arg1));
    }

    public A withNewOwnerAndRepository(int[] arg1,int arg2,int arg3) {
        return (A)withOwnerAndRepository(new String(arg1, arg2, arg3));
    }

    public A withNewOwnerAndRepository(char[] arg1) {
        return (A)withOwnerAndRepository(new String(arg1));
    }

    public A withNewOwnerAndRepository(StringBuffer arg1) {
        return (A)withOwnerAndRepository(new String(arg1));
    }

    public A withNewOwnerAndRepository(byte[] arg1,int arg2) {
        return (A)withOwnerAndRepository(new String(arg1, arg2));
    }

    public A withNewOwnerAndRepository(byte[] arg1) {
        return (A)withOwnerAndRepository(new String(arg1));
    }

    public A withNewOwnerAndRepository(char[] arg1,int arg2,int arg3) {
        return (A)withOwnerAndRepository(new String(arg1, arg2, arg3));
    }

    public A withNewOwnerAndRepository(byte[] arg1,int arg2,int arg3) {
        return (A)withOwnerAndRepository(new String(arg1, arg2, arg3));
    }

    public A withNewOwnerAndRepository(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withOwnerAndRepository(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewOwnerAndRepository(String arg1) {
        return (A)withOwnerAndRepository(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecretToken instead.
 * @return The buildable object.
 */
@Deprecated public SecretValueFromSource getSecretToken() {
        return this.secretToken!=null?this.secretToken.build():null;
    }

    public SecretValueFromSource buildSecretToken() {
        return this.secretToken!=null?this.secretToken.build():null;
    }

    public A withSecretToken(SecretValueFromSource secretToken) {
        _visitables.get("secretToken").remove(this.secretToken);
        if (secretToken!=null){ this.secretToken= new SecretValueFromSourceBuilder(secretToken); _visitables.get("secretToken").add(this.secretToken);} return (A) this;
    }

    public Boolean hasSecretToken() {
        return this.secretToken != null;
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SecretTokenNested<A> withNewSecretToken() {
        return new SecretTokenNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SecretTokenNested<A> withNewSecretTokenLike(SecretValueFromSource item) {
        return new SecretTokenNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SecretTokenNested<A> editSecretToken() {
        return withNewSecretTokenLike(getSecretToken());
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SecretTokenNested<A> editOrNewSecretToken() {
        return withNewSecretTokenLike(getSecretToken() != null ? getSecretToken(): new SecretValueFromSourceBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SecretTokenNested<A> editOrNewSecretTokenLike(SecretValueFromSource item) {
        return withNewSecretTokenLike(getSecretToken() != null ? getSecretToken(): item);
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public A withSecure(Boolean secure) {
        this.secure=secure; return (A) this;
    }

    public Boolean hasSecure() {
        return this.secure != null;
    }

    public A withNewSecure(String arg1) {
        return (A)withSecure(new Boolean(arg1));
    }

    public A withNewSecure(boolean arg1) {
        return (A)withSecure(new Boolean(arg1));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(int[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(char[] arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2) {
        return (A)withServiceAccountName(new String(arg1, arg2));
    }

    public A withNewServiceAccountName(byte[] arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(char[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public Destination getSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public Destination buildSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public A withSink(Destination sink) {
        _visitables.get("sink").remove(this.sink);
        if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink() {
        return this.sink != null;
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SinkNested<A> withNewSink() {
        return new SinkNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SinkNested<A> editSink() {
        return withNewSinkLike(getSink());
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SinkNested<A> editOrNewSink() {
        return withNewSinkLike(getSink() != null ? getSink(): new DestinationBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SinkNested<A> editOrNewSinkLike(Destination item) {
        return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GitHubSourceSpecFluentImpl that = (GitHubSourceSpecFluentImpl) o;
        if (accessToken != null ? !accessToken.equals(that.accessToken) :that.accessToken != null) return false;
        if (ceOverrides != null ? !ceOverrides.equals(that.ceOverrides) :that.ceOverrides != null) return false;
        if (eventTypes != null ? !eventTypes.equals(that.eventTypes) :that.eventTypes != null) return false;
        if (githubAPIURL != null ? !githubAPIURL.equals(that.githubAPIURL) :that.githubAPIURL != null) return false;
        if (ownerAndRepository != null ? !ownerAndRepository.equals(that.ownerAndRepository) :that.ownerAndRepository != null) return false;
        if (secretToken != null ? !secretToken.equals(that.secretToken) :that.secretToken != null) return false;
        if (secure != null ? !secure.equals(that.secure) :that.secure != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(accessToken,  ceOverrides,  eventTypes,  githubAPIURL,  ownerAndRepository,  secretToken,  secure,  serviceAccountName,  sink,  super.hashCode());
    }

    public class AccessTokenNestedImpl<N> extends SecretValueFromSourceFluentImpl<io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.AccessTokenNested<N>> implements io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.AccessTokenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretValueFromSourceBuilder builder;

            AccessTokenNestedImpl(SecretValueFromSource item) {
                this.builder = new SecretValueFromSourceBuilder(this, item);
                        
            }

            AccessTokenNestedImpl() {
                this.builder = new SecretValueFromSourceBuilder(this);
                        
            }

            public N and() {
                return (N) GitHubSourceSpecFluentImpl.this.withAccessToken(builder.build());
            }

            public N endAccessToken() {
                return and();
            }
    }


    public class CeOverridesNestedImpl<N> extends CloudEventOverridesFluentImpl<io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.CeOverridesNested<N>> implements io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.CeOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CloudEventOverridesBuilder builder;

            CeOverridesNestedImpl(CloudEventOverrides item) {
                this.builder = new CloudEventOverridesBuilder(this, item);
                        
            }

            CeOverridesNestedImpl() {
                this.builder = new CloudEventOverridesBuilder(this);
                        
            }

            public N and() {
                return (N) GitHubSourceSpecFluentImpl.this.withCeOverrides(builder.build());
            }

            public N endCeOverrides() {
                return and();
            }
    }


    public class SecretTokenNestedImpl<N> extends SecretValueFromSourceFluentImpl<io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SecretTokenNested<N>> implements io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SecretTokenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretValueFromSourceBuilder builder;

            SecretTokenNestedImpl(SecretValueFromSource item) {
                this.builder = new SecretValueFromSourceBuilder(this, item);
                        
            }

            SecretTokenNestedImpl() {
                this.builder = new SecretValueFromSourceBuilder(this);
                        
            }

            public N and() {
                return (N) GitHubSourceSpecFluentImpl.this.withSecretToken(builder.build());
            }

            public N endSecretToken() {
                return and();
            }
    }


    public class SinkNestedImpl<N> extends DestinationFluentImpl<io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SinkNested<N>> implements io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceSpecFluent.SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DestinationBuilder builder;

            SinkNestedImpl(Destination item) {
                this.builder = new DestinationBuilder(this, item);
                        
            }

            SinkNestedImpl() {
                this.builder = new DestinationBuilder(this);
                        
            }

            public N and() {
                return (N) GitHubSourceSpecFluentImpl.this.withSink(builder.build());
            }

            public N endSink() {
                return and();
            }
    }


}
