package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitLabSourceStatusBuilder extends GitLabSourceStatusFluentImpl<GitLabSourceStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<GitLabSourceStatus,GitLabSourceStatusBuilder> {

    GitLabSourceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public GitLabSourceStatusBuilder() {
        this(true);
    }

    public GitLabSourceStatusBuilder(Boolean validationEnabled) {
        this(new GitLabSourceStatus(), validationEnabled);
    }

    public GitLabSourceStatusBuilder(GitLabSourceStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public GitLabSourceStatusBuilder(GitLabSourceStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new GitLabSourceStatus(), validationEnabled);
    }

    public GitLabSourceStatusBuilder(GitLabSourceStatusFluent<?> fluent,GitLabSourceStatus instance) {
        this(fluent, instance, true);
    }

    public GitLabSourceStatusBuilder(GitLabSourceStatusFluent<?> fluent,GitLabSourceStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withId(instance.getId()); 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withCeAttributes(instance.getCeAttributes()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public GitLabSourceStatusBuilder(GitLabSourceStatus instance) {
        this(instance,true);
    }

    public GitLabSourceStatusBuilder(GitLabSourceStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withId(instance.getId()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withCeAttributes(instance.getCeAttributes()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.EditableGitLabSourceStatus build() {
        EditableGitLabSourceStatus buildable = new EditableGitLabSourceStatus(fluent.getId(),fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitLabSourceStatusBuilder that = (GitLabSourceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
