package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class KafkaBindingStatusFluentImpl<A extends KafkaBindingStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaBindingStatusFluent<A> {

    private java.util.Map<String,String> annotations;
    private List<ConditionBuilder> conditions;
    private Long observedGeneration;

    public KafkaBindingStatusFluentImpl() {
    }

    public KafkaBindingStatusFluentImpl(KafkaBindingStatus instance) {
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
    }

    public A addToAnnotations(String key,String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(java.util.Map<String,String> map) {
        if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(java.util.Map<String,String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getAnnotations() {
        return this.annotations;
    }

    public <K extends Object,V extends Object>A withAnnotations(java.util.Map<String,String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(Condition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          ConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions() {
        return build(conditions);
    }

    public List<Condition> buildConditions() {
        return build(conditions);
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A withNewObservedGeneration(long arg1) {
        return (A)withObservedGeneration(new Long(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaBindingStatusFluentImpl that = (KafkaBindingStatusFluentImpl) o;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(annotations,  conditions,  observedGeneration,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingStatusFluent.ConditionsNested<N>> implements io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,Condition item) {
                this.index = index;
                this.builder = new ConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBindingStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


}
