package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaSourceBuilder extends KafkaSourceFluentImpl<KafkaSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<KafkaSource,KafkaSourceBuilder> {

    KafkaSourceFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaSourceBuilder() {
        this(true);
    }

    public KafkaSourceBuilder(Boolean validationEnabled) {
        this(new KafkaSource(), validationEnabled);
    }

    public KafkaSourceBuilder(KafkaSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaSourceBuilder(KafkaSourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaSource(), validationEnabled);
    }

    public KafkaSourceBuilder(KafkaSourceFluent<?> fluent,KafkaSource instance) {
        this(fluent, instance, true);
    }

    public KafkaSourceBuilder(KafkaSourceFluent<?> fluent,KafkaSource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaSourceBuilder(KafkaSource instance) {
        this(instance,true);
    }

    public KafkaSourceBuilder(KafkaSource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.EditableKafkaSource build() {
        EditableKafkaSource buildable = new EditableKafkaSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaSourceBuilder that = (KafkaSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
