package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import java.lang.Deprecated;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluent;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface KafkaSourceSpecFluent<A extends KafkaSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToBootstrapServers(int index,String item);
    public A setToBootstrapServers(int index,String item);
    public A addToBootstrapServers(String... items);
    public A addAllToBootstrapServers(Collection<String> items);
    public A removeFromBootstrapServers(String... items);
    public A removeAllFromBootstrapServers(Collection<String> items);
    public List<String> getBootstrapServers();
    public String getBootstrapServer(int index);
    public String getFirstBootstrapServer();
    public String getLastBootstrapServer();
    public String getMatchingBootstrapServer(Predicate<String> predicate);
    public Boolean hasMatchingBootstrapServer(Predicate<String> predicate);
    public A withBootstrapServers(List<String> bootstrapServers);
    public A withBootstrapServers(String... bootstrapServers);
    public Boolean hasBootstrapServers();
    public A addNewBootstrapServer(StringBuilder arg1);
    public A addNewBootstrapServer(int[] arg1,int arg2,int arg3);
    public A addNewBootstrapServer(char[] arg1);
    public A addNewBootstrapServer(StringBuffer arg1);
    public A addNewBootstrapServer(byte[] arg1,int arg2);
    public A addNewBootstrapServer(byte[] arg1);
    public A addNewBootstrapServer(char[] arg1,int arg2,int arg3);
    public A addNewBootstrapServer(byte[] arg1,int arg2,int arg3);
    public A addNewBootstrapServer(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewBootstrapServer(String arg1);
    
/**
 * This method has been deprecated, please use method buildCeOverrides instead.
 * @return The buildable object.
 */
@Deprecated public CloudEventOverrides getCeOverrides();
    public CloudEventOverrides buildCeOverrides();
    public A withCeOverrides(CloudEventOverrides ceOverrides);
    public Boolean hasCeOverrides();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> withNewCeOverrides();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item);
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> editCeOverrides();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverrides();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item);
    public String getConsumerGroup();
    public A withConsumerGroup(String consumerGroup);
    public Boolean hasConsumerGroup();
    public A withNewConsumerGroup(StringBuilder arg1);
    public A withNewConsumerGroup(int[] arg1,int arg2,int arg3);
    public A withNewConsumerGroup(char[] arg1);
    public A withNewConsumerGroup(StringBuffer arg1);
    public A withNewConsumerGroup(byte[] arg1,int arg2);
    public A withNewConsumerGroup(byte[] arg1);
    public A withNewConsumerGroup(char[] arg1,int arg2,int arg3);
    public A withNewConsumerGroup(byte[] arg1,int arg2,int arg3);
    public A withNewConsumerGroup(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewConsumerGroup(String arg1);
    
/**
 * This method has been deprecated, please use method buildNet instead.
 * @return The buildable object.
 */
@Deprecated public KafkaNetSpec getNet();
    public KafkaNetSpec buildNet();
    public A withNet(KafkaNetSpec net);
    public Boolean hasNet();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> withNewNet();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> withNewNetLike(KafkaNetSpec item);
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> editNet();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> editOrNewNet();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> editOrNewNetLike(KafkaNetSpec item);
    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public Destination getSink();
    public Destination buildSink();
    public A withSink(Destination sink);
    public Boolean hasSink();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> withNewSink();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> withNewSinkLike(Destination item);
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> editSink();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> editOrNewSink();
    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> editOrNewSinkLike(Destination item);
    public A addToTopics(int index,String item);
    public A setToTopics(int index,String item);
    public A addToTopics(String... items);
    public A addAllToTopics(Collection<String> items);
    public A removeFromTopics(String... items);
    public A removeAllFromTopics(Collection<String> items);
    public List<String> getTopics();
    public String getTopic(int index);
    public String getFirstTopic();
    public String getLastTopic();
    public String getMatchingTopic(Predicate<String> predicate);
    public Boolean hasMatchingTopic(Predicate<String> predicate);
    public A withTopics(List<String> topics);
    public A withTopics(String... topics);
    public Boolean hasTopics();
    public A addNewTopic(StringBuilder arg1);
    public A addNewTopic(int[] arg1,int arg2,int arg3);
    public A addNewTopic(char[] arg1);
    public A addNewTopic(StringBuffer arg1);
    public A addNewTopic(byte[] arg1,int arg2);
    public A addNewTopic(byte[] arg1);
    public A addNewTopic(char[] arg1,int arg2,int arg3);
    public A addNewTopic(byte[] arg1,int arg2,int arg3);
    public A addNewTopic(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewTopic(String arg1);
    public interface CeOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CloudEventOverridesFluent<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<N>> {

            public N and();
            public N endCeOverrides();    }


    public interface NetNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaNetSpecFluent<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<N>> {

            public N and();
            public N endNet();    }


    public interface SinkNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DestinationFluent<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<N>> {

            public N and();
            public N endSink();    }


}
