package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

public class KafkaSourceSpecFluentImpl<A extends KafkaSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaSourceSpecFluent<A> {

    private List<String> bootstrapServers;
    private CloudEventOverridesBuilder ceOverrides;
    private String consumerGroup;
    private KafkaNetSpecBuilder net;
    private DestinationBuilder sink;
    private List<String> topics;

    public KafkaSourceSpecFluentImpl() {
    }

    public KafkaSourceSpecFluentImpl(KafkaSourceSpec instance) {
        this.withBootstrapServers(instance.getBootstrapServers()); 
        this.withCeOverrides(instance.getCeOverrides()); 
        this.withConsumerGroup(instance.getConsumerGroup()); 
        this.withNet(instance.getNet()); 
        this.withSink(instance.getSink()); 
        this.withTopics(instance.getTopics()); 
    }

    public A addToBootstrapServers(int index,String item) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
        this.bootstrapServers.add(index, item);
        return (A)this;
    }

    public A setToBootstrapServers(int index,String item) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
        this.bootstrapServers.set(index, item); return (A)this;
    }

    public A addToBootstrapServers(String... items) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
        for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
    }

    public A addAllToBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {this.bootstrapServers = new ArrayList<String>();}
        for (String item : items) {this.bootstrapServers.add(item);} return (A)this;
    }

    public A removeFromBootstrapServers(String... items) {
        for (String item : items) {if (this.bootstrapServers!= null){ this.bootstrapServers.remove(item);}} return (A)this;
    }

    public A removeAllFromBootstrapServers(Collection<String> items) {
        for (String item : items) {if (this.bootstrapServers!= null){ this.bootstrapServers.remove(item);}} return (A)this;
    }

    public List<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getBootstrapServer(int index) {
        return this.bootstrapServers.get(index);
    }

    public String getFirstBootstrapServer() {
        return this.bootstrapServers.get(0);
    }

    public String getLastBootstrapServer() {
        return this.bootstrapServers.get(bootstrapServers.size() - 1);
    }

    public String getMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item: bootstrapServers) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item: bootstrapServers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withBootstrapServers(List<String> bootstrapServers) {
        if (this.bootstrapServers != null) { _visitables.get("bootstrapServers").removeAll(this.bootstrapServers);}
        if (bootstrapServers != null) {this.bootstrapServers = new ArrayList<String>(); for (String item : bootstrapServers){this.addToBootstrapServers(item);}} else { this.bootstrapServers = null;} return (A) this;
    }

    public A withBootstrapServers(String... bootstrapServers) {
        if (this.bootstrapServers != null) {this.bootstrapServers.clear();}
        if (bootstrapServers != null) {for (String item :bootstrapServers){ this.addToBootstrapServers(item);}} return (A) this;
    }

    public Boolean hasBootstrapServers() {
        return bootstrapServers != null && !bootstrapServers.isEmpty();
    }

    public A addNewBootstrapServer(StringBuilder arg1) {
        return (A)addToBootstrapServers(new String(arg1));
    }

    public A addNewBootstrapServer(int[] arg1,int arg2,int arg3) {
        return (A)addToBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A addNewBootstrapServer(char[] arg1) {
        return (A)addToBootstrapServers(new String(arg1));
    }

    public A addNewBootstrapServer(StringBuffer arg1) {
        return (A)addToBootstrapServers(new String(arg1));
    }

    public A addNewBootstrapServer(byte[] arg1,int arg2) {
        return (A)addToBootstrapServers(new String(arg1, arg2));
    }

    public A addNewBootstrapServer(byte[] arg1) {
        return (A)addToBootstrapServers(new String(arg1));
    }

    public A addNewBootstrapServer(char[] arg1,int arg2,int arg3) {
        return (A)addToBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A addNewBootstrapServer(byte[] arg1,int arg2,int arg3) {
        return (A)addToBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A addNewBootstrapServer(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToBootstrapServers(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewBootstrapServer(String arg1) {
        return (A)addToBootstrapServers(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildCeOverrides instead.
 * @return The buildable object.
 */
@Deprecated public CloudEventOverrides getCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides!=null?this.ceOverrides.build():null;
    }

    public A withCeOverrides(CloudEventOverrides ceOverrides) {
        _visitables.get("ceOverrides").remove(this.ceOverrides);
        if (ceOverrides!=null){ this.ceOverrides= new CloudEventOverridesBuilder(ceOverrides); _visitables.get("ceOverrides").add(this.ceOverrides);} return (A) this;
    }

    public Boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> withNewCeOverrides() {
        return new CeOverridesNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
        return new CeOverridesNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> editCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverrides() {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): new CloudEventOverridesBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
        return withNewCeOverridesLike(getCeOverrides() != null ? getCeOverrides(): item);
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public A withConsumerGroup(String consumerGroup) {
        this.consumerGroup=consumerGroup; return (A) this;
    }

    public Boolean hasConsumerGroup() {
        return this.consumerGroup != null;
    }

    public A withNewConsumerGroup(StringBuilder arg1) {
        return (A)withConsumerGroup(new String(arg1));
    }

    public A withNewConsumerGroup(int[] arg1,int arg2,int arg3) {
        return (A)withConsumerGroup(new String(arg1, arg2, arg3));
    }

    public A withNewConsumerGroup(char[] arg1) {
        return (A)withConsumerGroup(new String(arg1));
    }

    public A withNewConsumerGroup(StringBuffer arg1) {
        return (A)withConsumerGroup(new String(arg1));
    }

    public A withNewConsumerGroup(byte[] arg1,int arg2) {
        return (A)withConsumerGroup(new String(arg1, arg2));
    }

    public A withNewConsumerGroup(byte[] arg1) {
        return (A)withConsumerGroup(new String(arg1));
    }

    public A withNewConsumerGroup(char[] arg1,int arg2,int arg3) {
        return (A)withConsumerGroup(new String(arg1, arg2, arg3));
    }

    public A withNewConsumerGroup(byte[] arg1,int arg2,int arg3) {
        return (A)withConsumerGroup(new String(arg1, arg2, arg3));
    }

    public A withNewConsumerGroup(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withConsumerGroup(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewConsumerGroup(String arg1) {
        return (A)withConsumerGroup(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNet instead.
 * @return The buildable object.
 */
@Deprecated public KafkaNetSpec getNet() {
        return this.net!=null?this.net.build():null;
    }

    public KafkaNetSpec buildNet() {
        return this.net!=null?this.net.build():null;
    }

    public A withNet(KafkaNetSpec net) {
        _visitables.get("net").remove(this.net);
        if (net!=null){ this.net= new KafkaNetSpecBuilder(net); _visitables.get("net").add(this.net);} return (A) this;
    }

    public Boolean hasNet() {
        return this.net != null;
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> withNewNet() {
        return new NetNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> withNewNetLike(KafkaNetSpec item) {
        return new NetNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> editNet() {
        return withNewNetLike(getNet());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> editOrNewNet() {
        return withNewNetLike(getNet() != null ? getNet(): new KafkaNetSpecBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<A> editOrNewNetLike(KafkaNetSpec item) {
        return withNewNetLike(getNet() != null ? getNet(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public Destination getSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public Destination buildSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public A withSink(Destination sink) {
        _visitables.get("sink").remove(this.sink);
        if (sink!=null){ this.sink= new DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink() {
        return this.sink != null;
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> withNewSink() {
        return new SinkNestedImpl();
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNestedImpl(item);
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> editSink() {
        return withNewSinkLike(getSink());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> editOrNewSink() {
        return withNewSinkLike(getSink() != null ? getSink(): new DestinationBuilder().build());
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<A> editOrNewSinkLike(Destination item) {
        return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public A addToTopics(int index,String item) {
        if (this.topics == null) {this.topics = new ArrayList<String>();}
        this.topics.add(index, item);
        return (A)this;
    }

    public A setToTopics(int index,String item) {
        if (this.topics == null) {this.topics = new ArrayList<String>();}
        this.topics.set(index, item); return (A)this;
    }

    public A addToTopics(String... items) {
        if (this.topics == null) {this.topics = new ArrayList<String>();}
        for (String item : items) {this.topics.add(item);} return (A)this;
    }

    public A addAllToTopics(Collection<String> items) {
        if (this.topics == null) {this.topics = new ArrayList<String>();}
        for (String item : items) {this.topics.add(item);} return (A)this;
    }

    public A removeFromTopics(String... items) {
        for (String item : items) {if (this.topics!= null){ this.topics.remove(item);}} return (A)this;
    }

    public A removeAllFromTopics(Collection<String> items) {
        for (String item : items) {if (this.topics!= null){ this.topics.remove(item);}} return (A)this;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public String getTopic(int index) {
        return this.topics.get(index);
    }

    public String getFirstTopic() {
        return this.topics.get(0);
    }

    public String getLastTopic() {
        return this.topics.get(topics.size() - 1);
    }

    public String getMatchingTopic(Predicate<String> predicate) {
        for (String item: topics) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTopic(Predicate<String> predicate) {
        for (String item: topics) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTopics(List<String> topics) {
        if (this.topics != null) { _visitables.get("topics").removeAll(this.topics);}
        if (topics != null) {this.topics = new ArrayList<String>(); for (String item : topics){this.addToTopics(item);}} else { this.topics = null;} return (A) this;
    }

    public A withTopics(String... topics) {
        if (this.topics != null) {this.topics.clear();}
        if (topics != null) {for (String item :topics){ this.addToTopics(item);}} return (A) this;
    }

    public Boolean hasTopics() {
        return topics != null && !topics.isEmpty();
    }

    public A addNewTopic(StringBuilder arg1) {
        return (A)addToTopics(new String(arg1));
    }

    public A addNewTopic(int[] arg1,int arg2,int arg3) {
        return (A)addToTopics(new String(arg1, arg2, arg3));
    }

    public A addNewTopic(char[] arg1) {
        return (A)addToTopics(new String(arg1));
    }

    public A addNewTopic(StringBuffer arg1) {
        return (A)addToTopics(new String(arg1));
    }

    public A addNewTopic(byte[] arg1,int arg2) {
        return (A)addToTopics(new String(arg1, arg2));
    }

    public A addNewTopic(byte[] arg1) {
        return (A)addToTopics(new String(arg1));
    }

    public A addNewTopic(char[] arg1,int arg2,int arg3) {
        return (A)addToTopics(new String(arg1, arg2, arg3));
    }

    public A addNewTopic(byte[] arg1,int arg2,int arg3) {
        return (A)addToTopics(new String(arg1, arg2, arg3));
    }

    public A addNewTopic(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToTopics(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewTopic(String arg1) {
        return (A)addToTopics(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaSourceSpecFluentImpl that = (KafkaSourceSpecFluentImpl) o;
        if (bootstrapServers != null ? !bootstrapServers.equals(that.bootstrapServers) :that.bootstrapServers != null) return false;
        if (ceOverrides != null ? !ceOverrides.equals(that.ceOverrides) :that.ceOverrides != null) return false;
        if (consumerGroup != null ? !consumerGroup.equals(that.consumerGroup) :that.consumerGroup != null) return false;
        if (net != null ? !net.equals(that.net) :that.net != null) return false;
        if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
        if (topics != null ? !topics.equals(that.topics) :that.topics != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(bootstrapServers,  ceOverrides,  consumerGroup,  net,  sink,  topics,  super.hashCode());
    }

    public class CeOverridesNestedImpl<N> extends CloudEventOverridesFluentImpl<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<N>> implements io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.CeOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CloudEventOverridesBuilder builder;

            CeOverridesNestedImpl(CloudEventOverrides item) {
                this.builder = new CloudEventOverridesBuilder(this, item);
                        
            }

            CeOverridesNestedImpl() {
                this.builder = new CloudEventOverridesBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSourceSpecFluentImpl.this.withCeOverrides(builder.build());
            }

            public N endCeOverrides() {
                return and();
            }
    }


    public class NetNestedImpl<N> extends KafkaNetSpecFluentImpl<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<N>> implements io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.NetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaNetSpecBuilder builder;

            NetNestedImpl(KafkaNetSpec item) {
                this.builder = new KafkaNetSpecBuilder(this, item);
                        
            }

            NetNestedImpl() {
                this.builder = new KafkaNetSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSourceSpecFluentImpl.this.withNet(builder.build());
            }

            public N endNet() {
                return and();
            }
    }


    public class SinkNestedImpl<N> extends DestinationFluentImpl<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<N>> implements io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent.SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DestinationBuilder builder;

            SinkNestedImpl(Destination item) {
                this.builder = new DestinationBuilder(this, item);
                        
            }

            SinkNestedImpl() {
                this.builder = new DestinationBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSourceSpecFluentImpl.this.withSink(builder.build());
            }

            public N endSink() {
                return and();
            }
    }


}
