package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaTLSSpecBuilder extends KafkaTLSSpecFluentImpl<KafkaTLSSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<KafkaTLSSpec,KafkaTLSSpecBuilder> {

    KafkaTLSSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaTLSSpecBuilder() {
        this(true);
    }

    public KafkaTLSSpecBuilder(Boolean validationEnabled) {
        this(new KafkaTLSSpec(), validationEnabled);
    }

    public KafkaTLSSpecBuilder(KafkaTLSSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaTLSSpecBuilder(KafkaTLSSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaTLSSpec(), validationEnabled);
    }

    public KafkaTLSSpecBuilder(KafkaTLSSpecFluent<?> fluent,KafkaTLSSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaTLSSpecBuilder(KafkaTLSSpecFluent<?> fluent,KafkaTLSSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCaCert(instance.getCaCert()); 
        fluent.withCert(instance.getCert()); 
        fluent.withEnable(instance.getEnable()); 
        fluent.withKey(instance.getKey()); 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaTLSSpecBuilder(KafkaTLSSpec instance) {
        this(instance,true);
    }

    public KafkaTLSSpecBuilder(KafkaTLSSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCaCert(instance.getCaCert()); 
        this.withCert(instance.getCert()); 
        this.withEnable(instance.getEnable()); 
        this.withKey(instance.getKey()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.EditableKafkaTLSSpec build() {
        EditableKafkaTLSSpec buildable = new EditableKafkaTLSSpec(fluent.getCaCert(),fluent.getCert(),fluent.getEnable(),fluent.getKey());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaTLSSpecBuilder that = (KafkaTLSSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
