package io.fabric8.knative.eventing.contrib.prometheus.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusSourceBuilder extends PrometheusSourceFluentImpl<PrometheusSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PrometheusSource,PrometheusSourceBuilder> {

    PrometheusSourceFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusSourceBuilder() {
        this(true);
    }

    public PrometheusSourceBuilder(Boolean validationEnabled) {
        this(new PrometheusSource(), validationEnabled);
    }

    public PrometheusSourceBuilder(PrometheusSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public PrometheusSourceBuilder(PrometheusSourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PrometheusSource(), validationEnabled);
    }

    public PrometheusSourceBuilder(PrometheusSourceFluent<?> fluent,PrometheusSource instance) {
        this(fluent, instance, true);
    }

    public PrometheusSourceBuilder(PrometheusSourceFluent<?> fluent,PrometheusSource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public PrometheusSourceBuilder(PrometheusSource instance) {
        this(instance,true);
    }

    public PrometheusSourceBuilder(PrometheusSource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.EditablePrometheusSource build() {
        EditablePrometheusSource buildable = new EditablePrometheusSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PrometheusSourceBuilder that = (PrometheusSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
