package io.fabric8.knative.eventing.contrib.prometheus.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusSourceSpecBuilder extends PrometheusSourceSpecFluentImpl<PrometheusSourceSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PrometheusSourceSpec,PrometheusSourceSpecBuilder> {

    PrometheusSourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusSourceSpecBuilder() {
        this(true);
    }

    public PrometheusSourceSpecBuilder(Boolean validationEnabled) {
        this(new PrometheusSourceSpec(), validationEnabled);
    }

    public PrometheusSourceSpecBuilder(PrometheusSourceSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public PrometheusSourceSpecBuilder(PrometheusSourceSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PrometheusSourceSpec(), validationEnabled);
    }

    public PrometheusSourceSpecBuilder(PrometheusSourceSpecFluent<?> fluent,PrometheusSourceSpec instance) {
        this(fluent, instance, true);
    }

    public PrometheusSourceSpecBuilder(PrometheusSourceSpecFluent<?> fluent,PrometheusSourceSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAuthTokenFile(instance.getAuthTokenFile()); 
        fluent.withCaCertConfigMap(instance.getCaCertConfigMap()); 
        fluent.withPromQL(instance.getPromQL()); 
        fluent.withSchedule(instance.getSchedule()); 
        fluent.withServerURL(instance.getServerURL()); 
        fluent.withServiceAccountName(instance.getServiceAccountName()); 
        fluent.withSink(instance.getSink()); 
        fluent.withStep(instance.getStep()); 
        this.validationEnabled = validationEnabled; 
    }

    public PrometheusSourceSpecBuilder(PrometheusSourceSpec instance) {
        this(instance,true);
    }

    public PrometheusSourceSpecBuilder(PrometheusSourceSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAuthTokenFile(instance.getAuthTokenFile()); 
        this.withCaCertConfigMap(instance.getCaCertConfigMap()); 
        this.withPromQL(instance.getPromQL()); 
        this.withSchedule(instance.getSchedule()); 
        this.withServerURL(instance.getServerURL()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSink(instance.getSink()); 
        this.withStep(instance.getStep()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.EditablePrometheusSourceSpec build() {
        EditablePrometheusSourceSpec buildable = new EditablePrometheusSourceSpec(fluent.getAuthTokenFile(),fluent.getCaCertConfigMap(),fluent.getPromQL(),fluent.getSchedule(),fluent.getServerURL(),fluent.getServiceAccountName(),fluent.getSink(),fluent.getStep());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PrometheusSourceSpecBuilder that = (PrometheusSourceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
