package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerListBuilder extends TriggerListFluentImpl<TriggerListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<TriggerList,TriggerListBuilder> {

    TriggerListFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerListBuilder() {
        this(true);
    }

    public TriggerListBuilder(Boolean validationEnabled) {
        this(new TriggerList(), validationEnabled);
    }

    public TriggerListBuilder(TriggerListFluent<?> fluent) {
        this(fluent, true);
    }

    public TriggerListBuilder(TriggerListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new TriggerList(), validationEnabled);
    }

    public TriggerListBuilder(TriggerListFluent<?> fluent,TriggerList instance) {
        this(fluent, instance, true);
    }

    public TriggerListBuilder(TriggerListFluent<?> fluent,TriggerList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public TriggerListBuilder(TriggerList instance) {
        this(instance,true);
    }

    public TriggerListBuilder(TriggerList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.v1.EditableTriggerList build() {
        EditableTriggerList buildable = new EditableTriggerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerListBuilder that = (TriggerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
