package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SequenceSubscriptionStatusBuilder extends SequenceSubscriptionStatusFluentImpl<SequenceSubscriptionStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<SequenceSubscriptionStatus,SequenceSubscriptionStatusBuilder> {

    SequenceSubscriptionStatusFluent<?> fluent;
    Boolean validationEnabled;

    public SequenceSubscriptionStatusBuilder() {
        this(true);
    }

    public SequenceSubscriptionStatusBuilder(Boolean validationEnabled) {
        this(new SequenceSubscriptionStatus(), validationEnabled);
    }

    public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SequenceSubscriptionStatus(), validationEnabled);
    }

    public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatusFluent<?> fluent,SequenceSubscriptionStatus instance) {
        this(fluent, instance, true);
    }

    public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatusFluent<?> fluent,SequenceSubscriptionStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReady(instance.getReady()); 
        fluent.withSubscription(instance.getSubscription()); 
        this.validationEnabled = validationEnabled; 
    }

    public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatus instance) {
        this(instance,true);
    }

    public SequenceSubscriptionStatusBuilder(SequenceSubscriptionStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withReady(instance.getReady()); 
        this.withSubscription(instance.getSubscription()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.flows.v1.EditableSequenceSubscriptionStatus build() {
        EditableSequenceSubscriptionStatus buildable = new EditableSequenceSubscriptionStatus(fluent.getReady(),fluent.getSubscription());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SequenceSubscriptionStatusBuilder that = (SequenceSubscriptionStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
