package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerStatusesBuilder extends ContainerStatusesFluentImpl<ContainerStatusesBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ContainerStatuses,ContainerStatusesBuilder> {

    ContainerStatusesFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStatusesBuilder() {
        this(true);
    }

    public ContainerStatusesBuilder(Boolean validationEnabled) {
        this(new ContainerStatuses(), validationEnabled);
    }

    public ContainerStatusesBuilder(ContainerStatusesFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerStatusesBuilder(ContainerStatusesFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ContainerStatuses(), validationEnabled);
    }

    public ContainerStatusesBuilder(ContainerStatusesFluent<?> fluent,ContainerStatuses instance) {
        this(fluent, instance, true);
    }

    public ContainerStatusesBuilder(ContainerStatusesFluent<?> fluent,ContainerStatuses instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withImageDigest(instance.getImageDigest()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerStatusesBuilder(ContainerStatuses instance) {
        this(instance,true);
    }

    public ContainerStatusesBuilder(ContainerStatuses instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withImageDigest(instance.getImageDigest()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1.EditableContainerStatuses build() {
        EditableContainerStatuses buildable = new EditableContainerStatuses(fluent.getImageDigest(),fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerStatusesBuilder that = (ContainerStatusesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
