package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class RouteStatusFluentImpl<A extends RouteStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RouteStatusFluent<A> {

    private AddressableBuilder address;
    private java.util.Map<String,String> annotations;
    private List<ConditionBuilder> conditions;
    private Long observedGeneration;
    private List<TrafficTargetBuilder> traffic;
    private String url;

    public RouteStatusFluentImpl() {
    }

    public RouteStatusFluentImpl(RouteStatus instance) {
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withTraffic(instance.getTraffic()); 
        this.withUrl(instance.getUrl()); 
    }

    
/**
 * This method has been deprecated, please use method buildAddress instead.
 * @return The buildable object.
 */
@Deprecated public Addressable getAddress() {
        return this.address!=null?this.address.build():null;
    }

    public Addressable buildAddress() {
        return this.address!=null?this.address.build():null;
    }

    public A withAddress(Addressable address) {
        _visitables.get("address").remove(this.address);
        if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public Boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(String url) {
        return (A)withAddress(new Addressable(url));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<A> withNewAddress() {
        return new AddressNestedImpl();
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNestedImpl(item);
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<A> editAddress() {
        return withNewAddressLike(getAddress());
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<A> editOrNewAddress() {
        return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item) {
        return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A addToAnnotations(String key,String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(java.util.Map<String,String> map) {
        if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(java.util.Map<String,String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getAnnotations() {
        return this.annotations;
    }

    public <K extends Object,V extends Object>A withAnnotations(java.util.Map<String,String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(Condition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          ConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions() {
        return build(conditions);
    }

    public List<Condition> buildConditions() {
        return build(conditions);
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A withNewObservedGeneration(long arg1) {
        return (A)withObservedGeneration(new Long(arg1));
    }

    public A addToTraffic(int index,TrafficTarget item) {
        if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
        TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(index >= 0 ? index : _visitables.get("traffic").size(), builder);this.traffic.add(index >= 0 ? index : traffic.size(), builder); return (A)this;
    }

    public A setToTraffic(int index,TrafficTarget item) {
        if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
        TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
        if (index < 0 || index >= _visitables.get("traffic").size()) { _visitables.get("traffic").add(builder); } else { _visitables.get("traffic").set(index, builder);}
        if (index < 0 || index >= traffic.size()) { traffic.add(builder); } else { traffic.set(index, builder);}
         return (A)this;
    }

    public A addToTraffic(TrafficTarget... items) {
        if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
        for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A addAllToTraffic(Collection<TrafficTarget> items) {
        if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
        for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A removeFromTraffic(TrafficTarget... items) {
        for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    public A removeAllFromTraffic(Collection<TrafficTarget> items) {
        for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTraffic(Predicate<TrafficTargetBuilder> predicate) {
        if (traffic == null) return (A) this;
        final Iterator<TrafficTargetBuilder> each = traffic.iterator();
        final List visitables = _visitables.get("traffic");
        while (each.hasNext()) {
          TrafficTargetBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTraffic instead.
 * @return The buildable object.
 */
@Deprecated public List<TrafficTarget> getTraffic() {
        return build(traffic);
    }

    public List<TrafficTarget> buildTraffic() {
        return build(traffic);
    }

    public TrafficTarget buildTraffic(int index) {
        return this.traffic.get(index).build();
    }

    public TrafficTarget buildFirstTraffic() {
        return this.traffic.get(0).build();
    }

    public TrafficTarget buildLastTraffic() {
        return this.traffic.get(traffic.size() - 1).build();
    }

    public TrafficTarget buildMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        for (TrafficTargetBuilder item: traffic) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        for (TrafficTargetBuilder item: traffic) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTraffic(List<TrafficTarget> traffic) {
        if (this.traffic != null) { _visitables.get("traffic").removeAll(this.traffic);}
        if (traffic != null) {this.traffic = new ArrayList<TrafficTargetBuilder>(); for (TrafficTarget item : traffic){this.addToTraffic(item);}} else { this.traffic = null;} return (A) this;
    }

    public A withTraffic(TrafficTarget... traffic) {
        if (this.traffic != null) {this.traffic.clear();}
        if (traffic != null) {for (TrafficTarget item :traffic){ this.addToTraffic(item);}} return (A) this;
    }

    public Boolean hasTraffic() {
        return traffic != null && !traffic.isEmpty();
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> addNewTraffic() {
        return new TrafficNestedImpl();
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> addNewTrafficLike(TrafficTarget item) {
        return new TrafficNestedImpl(-1, item);
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> setNewTrafficLike(int index,TrafficTarget item) {
        return new TrafficNestedImpl(index, item);
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> editTraffic(int index) {
        if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
        return setNewTrafficLike(index, buildTraffic(index));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> editFirstTraffic() {
        if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
        return setNewTrafficLike(0, buildTraffic(0));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> editLastTraffic() {
        int index = traffic.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
        return setNewTrafficLike(index, buildTraffic(index));
    }

    public io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<A> editMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        int index = -1;
        for (int i=0;i<traffic.size();i++) { 
        if (predicate.test(traffic.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
        return setNewTrafficLike(index, buildTraffic(index));
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url=url; return (A) this;
    }

    public Boolean hasUrl() {
        return this.url != null;
    }

    public A withNewUrl(StringBuilder arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(int[] arg1,int arg2,int arg3) {
        return (A)withUrl(new String(arg1, arg2, arg3));
    }

    public A withNewUrl(char[] arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(byte[] arg1,int arg2) {
        return (A)withUrl(new String(arg1, arg2));
    }

    public A withNewUrl(byte[] arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(char[] arg1,int arg2,int arg3) {
        return (A)withUrl(new String(arg1, arg2, arg3));
    }

    public A withNewUrl(byte[] arg1,int arg2,int arg3) {
        return (A)withUrl(new String(arg1, arg2, arg3));
    }

    public A withNewUrl(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUrl(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUrl(String arg1) {
        return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RouteStatusFluentImpl that = (RouteStatusFluentImpl) o;
        if (address != null ? !address.equals(that.address) :that.address != null) return false;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        if (traffic != null ? !traffic.equals(that.traffic) :that.traffic != null) return false;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(address,  annotations,  conditions,  observedGeneration,  traffic,  url,  super.hashCode());
    }

    public class AddressNestedImpl<N> extends AddressableFluentImpl<io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<N>> implements io.fabric8.knative.serving.v1.RouteStatusFluent.AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AddressableBuilder builder;

            AddressNestedImpl(Addressable item) {
                this.builder = new AddressableBuilder(this, item);
                        
            }

            AddressNestedImpl() {
                this.builder = new AddressableBuilder(this);
                        
            }

            public N and() {
                return (N) RouteStatusFluentImpl.this.withAddress(builder.build());
            }

            public N endAddress() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<N>> implements io.fabric8.knative.serving.v1.RouteStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,Condition item) {
                this.index = index;
                this.builder = new ConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) RouteStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class TrafficNestedImpl<N> extends TrafficTargetFluentImpl<io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<N>> implements io.fabric8.knative.serving.v1.RouteStatusFluent.TrafficNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TrafficTargetBuilder builder;
        private final int index;

            TrafficNestedImpl(int index,TrafficTarget item) {
                this.index = index;
                this.builder = new TrafficTargetBuilder(this, item);
                        
            }

            TrafficNestedImpl() {
                this.index = -1;
                this.builder = new TrafficTargetBuilder(this);
                        
            }

            public N and() {
                return (N) RouteStatusFluentImpl.this.setToTraffic(index,builder.build());
            }

            public N endTraffic() {
                return and();
            }
    }


}
