/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannelSpec;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannelSpecFluent;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaChannelSpecFluentImpl<A extends KafkaChannelSpecFluent<A>>
extends BaseFluent<A>
implements KafkaChannelSpecFluent<A> {
    private DeliverySpecBuilder delivery;
    private Integer numPartitions;
    private Integer replicationFactor;
    private List<SubscriberSpecBuilder> subscribers;

    public KafkaChannelSpecFluentImpl() {
    }

    public KafkaChannelSpecFluentImpl(KafkaChannelSpec instance) {
        this.withDelivery(instance.getDelivery());
        this.withNumPartitions(instance.getNumPartitions());
        this.withReplicationFactor(instance.getReplicationFactor());
        this.withSubscribers(instance.getSubscribers());
    }

    @Override
    @Deprecated
    public DeliverySpec getDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    @Override
    public DeliverySpec buildDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    @Override
    public A withDelivery(DeliverySpec delivery) {
        this._visitables.get((Object)"delivery").remove(this.delivery);
        if (delivery != null) {
            this.delivery = new DeliverySpecBuilder(delivery);
            this._visitables.get((Object)"delivery").add(this.delivery);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDelivery() {
        return this.delivery != null;
    }

    @Override
    public KafkaChannelSpecFluent.DeliveryNested<A> withNewDelivery() {
        return new DeliveryNestedImpl();
    }

    @Override
    public KafkaChannelSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNestedImpl(item);
    }

    @Override
    public KafkaChannelSpecFluent.DeliveryNested<A> editDelivery() {
        return this.withNewDeliveryLike(this.getDelivery());
    }

    @Override
    public KafkaChannelSpecFluent.DeliveryNested<A> editOrNewDelivery() {
        return this.withNewDeliveryLike(this.getDelivery() != null ? this.getDelivery() : new DeliverySpecBuilder().build());
    }

    @Override
    public KafkaChannelSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return this.withNewDeliveryLike(this.getDelivery() != null ? this.getDelivery() : item);
    }

    @Override
    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    public A withNumPartitions(Integer numPartitions) {
        this.numPartitions = numPartitions;
        return (A)this;
    }

    @Override
    public Boolean hasNumPartitions() {
        return this.numPartitions != null;
    }

    @Override
    public A withNewNumPartitions(int arg0) {
        return this.withNumPartitions(new Integer(arg0));
    }

    @Override
    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    public A withReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
        return (A)this;
    }

    @Override
    public Boolean hasReplicationFactor() {
        return this.replicationFactor != null;
    }

    @Override
    public A withNewReplicationFactor(int arg0) {
        return this.withReplicationFactor(new Integer(arg0));
    }

    @Override
    public A addToSubscribers(int index, SubscriberSpec item) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList<SubscriberSpecBuilder>();
        }
        SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
        this._visitables.get((Object)"subscribers").add(index >= 0 ? index : this._visitables.get((Object)"subscribers").size(), builder);
        this.subscribers.add(index >= 0 ? index : this.subscribers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubscribers(int index, SubscriberSpec item) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList<SubscriberSpecBuilder>();
        }
        SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"subscribers").size()) {
            this._visitables.get((Object)"subscribers").add(builder);
        } else {
            this._visitables.get((Object)"subscribers").set(index, builder);
        }
        if (index < 0 || index >= this.subscribers.size()) {
            this.subscribers.add(builder);
        } else {
            this.subscribers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubscribers(SubscriberSpec ... items) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList<SubscriberSpecBuilder>();
        }
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubscribers(Collection<SubscriberSpec> items) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList<SubscriberSpecBuilder>();
        }
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubscribers(SubscriberSpec ... items) {
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").remove(builder);
            if (this.subscribers == null) continue;
            this.subscribers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubscribers(Collection<SubscriberSpec> items) {
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").remove(builder);
            if (this.subscribers == null) continue;
            this.subscribers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubscribers(Predicate<SubscriberSpecBuilder> predicate) {
        if (this.subscribers == null) {
            return (A)this;
        }
        Iterator<SubscriberSpecBuilder> each = this.subscribers.iterator();
        List visitables = this._visitables.get((Object)"subscribers");
        while (each.hasNext()) {
            SubscriberSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SubscriberSpec> getSubscribers() {
        return KafkaChannelSpecFluentImpl.build(this.subscribers);
    }

    @Override
    public List<SubscriberSpec> buildSubscribers() {
        return KafkaChannelSpecFluentImpl.build(this.subscribers);
    }

    @Override
    public SubscriberSpec buildSubscriber(int index) {
        return this.subscribers.get(index).build();
    }

    @Override
    public SubscriberSpec buildFirstSubscriber() {
        return this.subscribers.get(0).build();
    }

    @Override
    public SubscriberSpec buildLastSubscriber() {
        return this.subscribers.get(this.subscribers.size() - 1).build();
    }

    @Override
    public SubscriberSpec buildMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        for (SubscriberSpecBuilder item : this.subscribers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        for (SubscriberSpecBuilder item : this.subscribers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubscribers(List<SubscriberSpec> subscribers) {
        if (this.subscribers != null) {
            this._visitables.get((Object)"subscribers").removeAll(this.subscribers);
        }
        if (subscribers != null) {
            this.subscribers = new ArrayList<SubscriberSpecBuilder>();
            for (SubscriberSpec item : subscribers) {
                this.addToSubscribers(item);
            }
        } else {
            this.subscribers = null;
        }
        return (A)this;
    }

    @Override
    public A withSubscribers(SubscriberSpec ... subscribers) {
        if (this.subscribers != null) {
            this.subscribers.clear();
        }
        if (subscribers != null) {
            for (SubscriberSpec item : subscribers) {
                this.addToSubscribers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubscribers() {
        return this.subscribers != null && !this.subscribers.isEmpty();
    }

    @Override
    public KafkaChannelSpecFluent.SubscribersNested<A> addNewSubscriber() {
        return new SubscribersNestedImpl();
    }

    @Override
    public KafkaChannelSpecFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberSpec item) {
        return new SubscribersNestedImpl(-1, item);
    }

    @Override
    public KafkaChannelSpecFluent.SubscribersNested<A> setNewSubscriberLike(int index, SubscriberSpec item) {
        return new SubscribersNestedImpl(index, item);
    }

    @Override
    public KafkaChannelSpecFluent.SubscribersNested<A> editSubscriber(int index) {
        if (this.subscribers.size() <= index) {
            throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    @Override
    public KafkaChannelSpecFluent.SubscribersNested<A> editFirstSubscriber() {
        if (this.subscribers.size() == 0) {
            throw new RuntimeException("Can't edit first subscribers. The list is empty.");
        }
        return this.setNewSubscriberLike(0, this.buildSubscriber(0));
    }

    @Override
    public KafkaChannelSpecFluent.SubscribersNested<A> editLastSubscriber() {
        int index = this.subscribers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subscribers. The list is empty.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    @Override
    public KafkaChannelSpecFluent.SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subscribers.size(); ++i) {
            if (!predicate.test(this.subscribers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subscribers. No match found.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaChannelSpecFluentImpl that = (KafkaChannelSpecFluentImpl)o;
        if (this.delivery != null ? !this.delivery.equals(that.delivery) : that.delivery != null) {
            return false;
        }
        if (this.numPartitions != null ? !this.numPartitions.equals(that.numPartitions) : that.numPartitions != null) {
            return false;
        }
        if (this.replicationFactor != null ? !this.replicationFactor.equals(that.replicationFactor) : that.replicationFactor != null) {
            return false;
        }
        return !(this.subscribers != null ? !this.subscribers.equals(that.subscribers) : that.subscribers != null);
    }

    public int hashCode() {
        return Objects.hash(this.delivery, this.numPartitions, this.replicationFactor, this.subscribers, super.hashCode());
    }

    public class SubscribersNestedImpl<N>
    extends SubscriberSpecFluentImpl<KafkaChannelSpecFluent.SubscribersNested<N>>
    implements KafkaChannelSpecFluent.SubscribersNested<N>,
    Nested<N> {
        private final SubscriberSpecBuilder builder;
        private final int index;

        SubscribersNestedImpl(int index, SubscriberSpec item) {
            this.index = index;
            this.builder = new SubscriberSpecBuilder(this, item);
        }

        SubscribersNestedImpl() {
            this.index = -1;
            this.builder = new SubscriberSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaChannelSpecFluentImpl.this.setToSubscribers(this.index, this.builder.build());
        }

        @Override
        public N endSubscriber() {
            return this.and();
        }
    }

    public class DeliveryNestedImpl<N>
    extends DeliverySpecFluentImpl<KafkaChannelSpecFluent.DeliveryNested<N>>
    implements KafkaChannelSpecFluent.DeliveryNested<N>,
    Nested<N> {
        private final DeliverySpecBuilder builder;

        DeliveryNestedImpl(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        DeliveryNestedImpl() {
            this.builder = new DeliverySpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaChannelSpecFluentImpl.this.withDelivery(this.builder.build());
        }

        @Override
        public N endDelivery() {
            return this.and();
        }
    }
}

