package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerSpecBuilder extends io.fabric8.knative.eventing.v1.TriggerSpecFluentImpl<io.fabric8.knative.eventing.v1.TriggerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.eventing.v1.TriggerSpec,io.fabric8.knative.eventing.v1.TriggerSpecBuilder> {

    io.fabric8.knative.eventing.v1.TriggerSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TriggerSpecBuilder() {
        this(true);
    }

    public TriggerSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new TriggerSpec(), validationEnabled);
    }

    public TriggerSpecBuilder(io.fabric8.knative.eventing.v1.TriggerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public TriggerSpecBuilder(io.fabric8.knative.eventing.v1.TriggerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TriggerSpec(), validationEnabled);
    }

    public TriggerSpecBuilder(io.fabric8.knative.eventing.v1.TriggerSpecFluent<?> fluent,io.fabric8.knative.eventing.v1.TriggerSpec instance) {
        this(fluent, instance, true);
    }

    public TriggerSpecBuilder(io.fabric8.knative.eventing.v1.TriggerSpecFluent<?> fluent,io.fabric8.knative.eventing.v1.TriggerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBroker(instance.getBroker()); 
        fluent.withFilter(instance.getFilter()); 
        fluent.withSubscriber(instance.getSubscriber()); 
        this.validationEnabled = validationEnabled; 
    }

    public TriggerSpecBuilder(io.fabric8.knative.eventing.v1.TriggerSpec instance) {
        this(instance,true);
    }

    public TriggerSpecBuilder(io.fabric8.knative.eventing.v1.TriggerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBroker(instance.getBroker()); 
        this.withFilter(instance.getFilter()); 
        this.withSubscriber(instance.getSubscriber()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.v1.EditableTriggerSpec build() {
        EditableTriggerSpec buildable = new EditableTriggerSpec(fluent.getBroker(),fluent.getFilter(),fluent.getSubscriber());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TriggerSpecBuilder that = (TriggerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
