package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class RevisionStatusFluentImpl<A extends io.fabric8.knative.serving.v1.RevisionStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.serving.v1.RevisionStatusFluent<A> {

    private java.util.Map<java.lang.String,java.lang.String> annotations;
    private java.util.List<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> conditions;
    private java.util.List<io.fabric8.knative.serving.v1.ContainerStatusesBuilder> containerStatuses;
    private java.lang.String imageDigest;
    private java.lang.String logUrl;
    private java.lang.Long observedGeneration;
    private java.lang.String serviceName;

    public RevisionStatusFluentImpl() {
    }

    public RevisionStatusFluentImpl(io.fabric8.knative.serving.v1.RevisionStatus instance) {
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withContainerStatuses(instance.getContainerStatuses()); 
        this.withImageDigest(instance.getImageDigest()); 
        this.withLogUrl(instance.getLogUrl()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withServiceName(instance.getServiceName()); 
    }

    public A addToAnnotations(java.lang.String key,java.lang.String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null && map != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(java.lang.String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getAnnotations() {
        return this.annotations;
    }

    public <K,V>A withAnnotations(java.util.Map<java.lang.String,java.lang.String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(annotations);} return (A) this;
    }

    public java.lang.Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.knative.internal.pkg.apis.Condition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.knative.internal.pkg.apis.Condition> items) {
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        for (io.fabric8.knative.internal.pkg.apis.ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        for (io.fabric8.knative.internal.pkg.apis.ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>(); for (io.fabric8.knative.internal.pkg.apis.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.knative.internal.pkg.apis.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.fabric8.knative.serving.v1.RevisionStatusFluentImpl.ConditionsNestedImpl();
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.knative.internal.pkg.apis.Condition item) {
        return new io.fabric8.knative.serving.v1.RevisionStatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        return new io.fabric8.knative.serving.v1.RevisionStatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public A addToContainerStatuses(int index,io.fabric8.knative.serving.v1.ContainerStatuses item) {
        if (this.containerStatuses == null) {this.containerStatuses = new java.util.ArrayList<io.fabric8.knative.serving.v1.ContainerStatusesBuilder>();}
        io.fabric8.knative.serving.v1.ContainerStatusesBuilder builder = new io.fabric8.knative.serving.v1.ContainerStatusesBuilder(item);_visitables.get("containerStatuses").add(index >= 0 ? index : _visitables.get("containerStatuses").size(), builder);this.containerStatuses.add(index >= 0 ? index : containerStatuses.size(), builder); return (A)this;
    }

    public A setToContainerStatuses(int index,io.fabric8.knative.serving.v1.ContainerStatuses item) {
        if (this.containerStatuses == null) {this.containerStatuses = new java.util.ArrayList<io.fabric8.knative.serving.v1.ContainerStatusesBuilder>();}
        io.fabric8.knative.serving.v1.ContainerStatusesBuilder builder = new io.fabric8.knative.serving.v1.ContainerStatusesBuilder(item);
        if (index < 0 || index >= _visitables.get("containerStatuses").size()) { _visitables.get("containerStatuses").add(builder); } else { _visitables.get("containerStatuses").set(index, builder);}
        if (index < 0 || index >= containerStatuses.size()) { containerStatuses.add(builder); } else { containerStatuses.set(index, builder);}
         return (A)this;
    }

    public A addToContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatuses... items) {
        if (this.containerStatuses == null) {this.containerStatuses = new java.util.ArrayList<io.fabric8.knative.serving.v1.ContainerStatusesBuilder>();}
        for (io.fabric8.knative.serving.v1.ContainerStatuses item : items) {io.fabric8.knative.serving.v1.ContainerStatusesBuilder builder = new io.fabric8.knative.serving.v1.ContainerStatusesBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
    }

    public A addAllToContainerStatuses(java.util.Collection<io.fabric8.knative.serving.v1.ContainerStatuses> items) {
        if (this.containerStatuses == null) {this.containerStatuses = new java.util.ArrayList<io.fabric8.knative.serving.v1.ContainerStatusesBuilder>();}
        for (io.fabric8.knative.serving.v1.ContainerStatuses item : items) {io.fabric8.knative.serving.v1.ContainerStatusesBuilder builder = new io.fabric8.knative.serving.v1.ContainerStatusesBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
    }

    public A removeFromContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatuses... items) {
        for (io.fabric8.knative.serving.v1.ContainerStatuses item : items) {io.fabric8.knative.serving.v1.ContainerStatusesBuilder builder = new io.fabric8.knative.serving.v1.ContainerStatusesBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
    }

    public A removeAllFromContainerStatuses(java.util.Collection<io.fabric8.knative.serving.v1.ContainerStatuses> items) {
        for (io.fabric8.knative.serving.v1.ContainerStatuses item : items) {io.fabric8.knative.serving.v1.ContainerStatusesBuilder builder = new io.fabric8.knative.serving.v1.ContainerStatusesBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromContainerStatuses(java.util.function.Predicate<io.fabric8.knative.serving.v1.ContainerStatusesBuilder> predicate) {
        if (containerStatuses == null) return (A) this;
        final Iterator<io.fabric8.knative.serving.v1.ContainerStatusesBuilder> each = containerStatuses.iterator();
        final List visitables = _visitables.get("containerStatuses");
        while (each.hasNext()) {
          io.fabric8.knative.serving.v1.ContainerStatusesBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildContainerStatuses instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.knative.serving.v1.ContainerStatuses> getContainerStatuses() {
        return build(containerStatuses);
    }

    public java.util.List<io.fabric8.knative.serving.v1.ContainerStatuses> buildContainerStatuses() {
        return build(containerStatuses);
    }

    public io.fabric8.knative.serving.v1.ContainerStatuses buildContainerStatus(int index) {
        return this.containerStatuses.get(index).build();
    }

    public io.fabric8.knative.serving.v1.ContainerStatuses buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    public io.fabric8.knative.serving.v1.ContainerStatuses buildLastContainerStatus() {
        return this.containerStatuses.get(containerStatuses.size() - 1).build();
    }

    public io.fabric8.knative.serving.v1.ContainerStatuses buildMatchingContainerStatus(java.util.function.Predicate<io.fabric8.knative.serving.v1.ContainerStatusesBuilder> predicate) {
        for (io.fabric8.knative.serving.v1.ContainerStatusesBuilder item: containerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingContainerStatus(java.util.function.Predicate<io.fabric8.knative.serving.v1.ContainerStatusesBuilder> predicate) {
        for (io.fabric8.knative.serving.v1.ContainerStatusesBuilder item: containerStatuses) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withContainerStatuses(java.util.List<io.fabric8.knative.serving.v1.ContainerStatuses> containerStatuses) {
        if (this.containerStatuses != null) { _visitables.get("containerStatuses").removeAll(this.containerStatuses);}
        if (containerStatuses != null) {this.containerStatuses = new java.util.ArrayList<io.fabric8.knative.serving.v1.ContainerStatusesBuilder>(); for (io.fabric8.knative.serving.v1.ContainerStatuses item : containerStatuses){this.addToContainerStatuses(item);}} else { this.containerStatuses = null;} return (A) this;
    }

    public A withContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatuses... containerStatuses) {
        if (this.containerStatuses != null) {this.containerStatuses.clear();}
        if (containerStatuses != null) {for (io.fabric8.knative.serving.v1.ContainerStatuses item :containerStatuses){ this.addToContainerStatuses(item);}} return (A) this;
    }

    public java.lang.Boolean hasContainerStatuses() {
        return containerStatuses != null && !containerStatuses.isEmpty();
    }

    public A addNewContainerStatus(java.lang.String imageDigest,java.lang.String name) {
        return (A)addToContainerStatuses(new ContainerStatuses(imageDigest, name));
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
        return new io.fabric8.knative.serving.v1.RevisionStatusFluentImpl.ContainerStatusesNestedImpl();
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(io.fabric8.knative.serving.v1.ContainerStatuses item) {
        return new io.fabric8.knative.serving.v1.RevisionStatusFluentImpl.ContainerStatusesNestedImpl(-1, item);
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index,io.fabric8.knative.serving.v1.ContainerStatuses item) {
        return new io.fabric8.knative.serving.v1.RevisionStatusFluentImpl.ContainerStatusesNestedImpl(index, item);
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index) {
        if (containerStatuses.size() <= index) throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        return setNewContainerStatusLike(index, buildContainerStatus(index));
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
        if (containerStatuses.size() == 0) throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        return setNewContainerStatusLike(0, buildContainerStatus(0));
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
        int index = containerStatuses.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        return setNewContainerStatusLike(index, buildContainerStatus(index));
    }

    public io.fabric8.knative.serving.v1.RevisionStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(java.util.function.Predicate<io.fabric8.knative.serving.v1.ContainerStatusesBuilder> predicate) {
        int index = -1;
        for (int i=0;i<containerStatuses.size();i++) { 
        if (predicate.test(containerStatuses.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        return setNewContainerStatusLike(index, buildContainerStatus(index));
    }

    public java.lang.String getImageDigest() {
        return this.imageDigest;
    }

    public A withImageDigest(java.lang.String imageDigest) {
        this.imageDigest=imageDigest; return (A) this;
    }

    public java.lang.Boolean hasImageDigest() {
        return this.imageDigest != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImageDigest instead.
     */
        public A withNewImageDigest(java.lang.String arg0) {
        return (A)withImageDigest(new String(arg0));
    }

    public java.lang.String getLogUrl() {
        return this.logUrl;
    }

    public A withLogUrl(java.lang.String logUrl) {
        this.logUrl=logUrl; return (A) this;
    }

    public java.lang.Boolean hasLogUrl() {
        return this.logUrl != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLogUrl instead.
     */
        public A withNewLogUrl(java.lang.String arg0) {
        return (A)withLogUrl(new String(arg0));
    }

    public java.lang.Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(java.lang.Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public java.lang.Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public java.lang.String getServiceName() {
        return this.serviceName;
    }

    public A withServiceName(java.lang.String serviceName) {
        this.serviceName=serviceName; return (A) this;
    }

    public java.lang.Boolean hasServiceName() {
        return this.serviceName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withServiceName instead.
     */
        public A withNewServiceName(java.lang.String arg0) {
        return (A)withServiceName(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RevisionStatusFluentImpl that = (RevisionStatusFluentImpl) o;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (containerStatuses != null ? !containerStatuses.equals(that.containerStatuses) :that.containerStatuses != null) return false;
        if (imageDigest != null ? !imageDigest.equals(that.imageDigest) :that.imageDigest != null) return false;
        if (logUrl != null ? !logUrl.equals(that.logUrl) :that.logUrl != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(annotations,  conditions,  containerStatuses,  imageDigest,  logUrl,  observedGeneration,  serviceName,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl<io.fabric8.knative.serving.v1.RevisionStatusFluent.ConditionsNested<N>> implements io.fabric8.knative.serving.v1.RevisionStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
                this.index = index;
                this.builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) RevisionStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class ContainerStatusesNestedImpl<N> extends io.fabric8.knative.serving.v1.ContainerStatusesFluentImpl<io.fabric8.knative.serving.v1.RevisionStatusFluent.ContainerStatusesNested<N>> implements io.fabric8.knative.serving.v1.RevisionStatusFluent.ContainerStatusesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.serving.v1.ContainerStatusesBuilder builder;
        private final int index;

            ContainerStatusesNestedImpl(int index,io.fabric8.knative.serving.v1.ContainerStatuses item) {
                this.index = index;
                this.builder = new io.fabric8.knative.serving.v1.ContainerStatusesBuilder(this, item);
                        
            }

            ContainerStatusesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.knative.serving.v1.ContainerStatusesBuilder(this);
                        
            }

            public N and() {
                return (N) RevisionStatusFluentImpl.this.setToContainerStatuses(index,builder.build());
            }

            public N endContainerStatus() {
                return and();
            }
    }


}
