package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteSpecBuilder extends io.fabric8.knative.serving.v1.RouteSpecFluentImpl<io.fabric8.knative.serving.v1.RouteSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.serving.v1.RouteSpec,io.fabric8.knative.serving.v1.RouteSpecBuilder> {

    io.fabric8.knative.serving.v1.RouteSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RouteSpecBuilder() {
        this(true);
    }

    public RouteSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new RouteSpec(), validationEnabled);
    }

    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RouteSpec(), validationEnabled);
    }

    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpecFluent<?> fluent,io.fabric8.knative.serving.v1.RouteSpec instance) {
        this(fluent, instance, true);
    }

    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpecFluent<?> fluent,io.fabric8.knative.serving.v1.RouteSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTraffic(instance.getTraffic()); 
        this.validationEnabled = validationEnabled; 
    }

    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpec instance) {
        this(instance,true);
    }

    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withTraffic(instance.getTraffic()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1.EditableRouteSpec build() {
        EditableRouteSpec buildable = new EditableRouteSpec(fluent.getTraffic());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RouteSpecBuilder that = (RouteSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
