package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class SubscriptionStatusFluentImpl<A extends io.fabric8.knative.messaging.v1.SubscriptionStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.messaging.v1.SubscriptionStatusFluent<A> {

    private java.util.Map<java.lang.String,java.lang.String> annotations;
    private java.util.List<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> conditions;
    private java.lang.Long observedGeneration;
    private io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscriptionBuilder physicalSubscription;

    public SubscriptionStatusFluentImpl() {
    }

    public SubscriptionStatusFluentImpl(io.fabric8.knative.messaging.v1.SubscriptionStatus instance) {
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withPhysicalSubscription(instance.getPhysicalSubscription()); 
    }

    public A addToAnnotations(java.lang.String key,java.lang.String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null && map != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(java.lang.String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getAnnotations() {
        return this.annotations;
    }

    public <K,V>A withAnnotations(java.util.Map<java.lang.String,java.lang.String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(annotations);} return (A) this;
    }

    public java.lang.Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.knative.internal.pkg.apis.Condition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.knative.internal.pkg.apis.Condition> items) {
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        for (io.fabric8.knative.internal.pkg.apis.ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        for (io.fabric8.knative.internal.pkg.apis.ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>(); for (io.fabric8.knative.internal.pkg.apis.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.knative.internal.pkg.apis.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.fabric8.knative.messaging.v1.SubscriptionStatusFluentImpl.ConditionsNestedImpl();
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.knative.internal.pkg.apis.Condition item) {
        return new io.fabric8.knative.messaging.v1.SubscriptionStatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        return new io.fabric8.knative.messaging.v1.SubscriptionStatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public java.lang.Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(java.lang.Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public java.lang.Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPhysicalSubscription instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscription getPhysicalSubscription() {
        return this.physicalSubscription!=null?this.physicalSubscription.build():null;
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscription buildPhysicalSubscription() {
        return this.physicalSubscription!=null?this.physicalSubscription.build():null;
    }

    public A withPhysicalSubscription(io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscription physicalSubscription) {
        _visitables.get("physicalSubscription").remove(this.physicalSubscription);
        if (physicalSubscription!=null){ this.physicalSubscription= new io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscriptionBuilder(physicalSubscription); _visitables.get("physicalSubscription").add(this.physicalSubscription);} return (A) this;
    }

    public java.lang.Boolean hasPhysicalSubscription() {
        return this.physicalSubscription != null;
    }

    public A withNewPhysicalSubscription(java.lang.String deadLetterSinkUri,java.lang.String replyUri,java.lang.String subscriberUri) {
        return (A)withPhysicalSubscription(new SubscriptionStatusPhysicalSubscription(deadLetterSinkUri, replyUri, subscriberUri));
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.PhysicalSubscriptionNested<A> withNewPhysicalSubscription() {
        return new io.fabric8.knative.messaging.v1.SubscriptionStatusFluentImpl.PhysicalSubscriptionNestedImpl();
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.PhysicalSubscriptionNested<A> withNewPhysicalSubscriptionLike(io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscription item) {
        return new io.fabric8.knative.messaging.v1.SubscriptionStatusFluentImpl.PhysicalSubscriptionNestedImpl(item);
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.PhysicalSubscriptionNested<A> editPhysicalSubscription() {
        return withNewPhysicalSubscriptionLike(getPhysicalSubscription());
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.PhysicalSubscriptionNested<A> editOrNewPhysicalSubscription() {
        return withNewPhysicalSubscriptionLike(getPhysicalSubscription() != null ? getPhysicalSubscription(): new io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscriptionBuilder().build());
    }

    public io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.PhysicalSubscriptionNested<A> editOrNewPhysicalSubscriptionLike(io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscription item) {
        return withNewPhysicalSubscriptionLike(getPhysicalSubscription() != null ? getPhysicalSubscription(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubscriptionStatusFluentImpl that = (SubscriptionStatusFluentImpl) o;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        if (physicalSubscription != null ? !physicalSubscription.equals(that.physicalSubscription) :that.physicalSubscription != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(annotations,  conditions,  observedGeneration,  physicalSubscription,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl<io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.ConditionsNested<N>> implements io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
                this.index = index;
                this.builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) SubscriptionStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class PhysicalSubscriptionNestedImpl<N> extends io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscriptionFluentImpl<io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.PhysicalSubscriptionNested<N>> implements io.fabric8.knative.messaging.v1.SubscriptionStatusFluent.PhysicalSubscriptionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscriptionBuilder builder;

            PhysicalSubscriptionNestedImpl(io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscription item) {
                this.builder = new io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscriptionBuilder(this, item);
                        
            }

            PhysicalSubscriptionNestedImpl() {
                this.builder = new io.fabric8.knative.messaging.v1.SubscriptionStatusPhysicalSubscriptionBuilder(this);
                        
            }

            public N and() {
                return (N) SubscriptionStatusFluentImpl.this.withPhysicalSubscription(builder.build());
            }

            public N endPhysicalSubscription() {
                return and();
            }
    }


}
