package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.knative.serving.v1.ServiceStatusBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.knative.serving.v1.ServiceSpec;
import io.fabric8.knative.serving.v1.ServiceSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.knative.serving.v1.ServiceSpecBuilder;
import java.lang.Deprecated;
import io.fabric8.knative.serving.v1.ServiceStatus;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.knative.serving.v1.ServiceStatusFluentImpl;
import java.lang.Boolean;

public class ServiceFluentImpl<A extends io.fabric8.knative.serving.v1beta1.ServiceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.serving.v1beta1.ServiceFluent<A> {

    private java.lang.String apiVersion;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private io.fabric8.knative.serving.v1.ServiceSpecBuilder spec;
    private io.fabric8.knative.serving.v1.ServiceStatusBuilder status;

    public ServiceFluentImpl() {
    }

    public ServiceFluentImpl(io.fabric8.knative.serving.v1beta1.Service instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.knative.serving.v1beta1.ServiceFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.knative.serving.v1beta1.ServiceFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSpec instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.serving.v1.ServiceSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public io.fabric8.knative.serving.v1.ServiceSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(io.fabric8.knative.serving.v1.ServiceSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new io.fabric8.knative.serving.v1.ServiceSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public java.lang.Boolean hasSpec() {
        return this.spec != null;
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.SpecNested<A> withNewSpec() {
        return new io.fabric8.knative.serving.v1beta1.ServiceFluentImpl.SpecNestedImpl();
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.SpecNested<A> withNewSpecLike(io.fabric8.knative.serving.v1.ServiceSpec item) {
        return new io.fabric8.knative.serving.v1beta1.ServiceFluentImpl.SpecNestedImpl(item);
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new io.fabric8.knative.serving.v1.ServiceSpecBuilder().build());
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.SpecNested<A> editOrNewSpecLike(io.fabric8.knative.serving.v1.ServiceSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStatus instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.serving.v1.ServiceStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public io.fabric8.knative.serving.v1.ServiceStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(io.fabric8.knative.serving.v1.ServiceStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new io.fabric8.knative.serving.v1.ServiceStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public java.lang.Boolean hasStatus() {
        return this.status != null;
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.StatusNested<A> withNewStatus() {
        return new io.fabric8.knative.serving.v1beta1.ServiceFluentImpl.StatusNestedImpl();
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.StatusNested<A> withNewStatusLike(io.fabric8.knative.serving.v1.ServiceStatus item) {
        return new io.fabric8.knative.serving.v1beta1.ServiceFluentImpl.StatusNestedImpl(item);
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new io.fabric8.knative.serving.v1.ServiceStatusBuilder().build());
    }

    public io.fabric8.knative.serving.v1beta1.ServiceFluent.StatusNested<A> editOrNewStatusLike(io.fabric8.knative.serving.v1.ServiceStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServiceFluentImpl that = (ServiceFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.knative.serving.v1beta1.ServiceFluent.MetadataNested<N>> implements io.fabric8.knative.serving.v1beta1.ServiceFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class SpecNestedImpl<N> extends io.fabric8.knative.serving.v1.ServiceSpecFluentImpl<io.fabric8.knative.serving.v1beta1.ServiceFluent.SpecNested<N>> implements io.fabric8.knative.serving.v1beta1.ServiceFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.serving.v1.ServiceSpecBuilder builder;

            SpecNestedImpl(io.fabric8.knative.serving.v1.ServiceSpec item) {
                this.builder = new io.fabric8.knative.serving.v1.ServiceSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new io.fabric8.knative.serving.v1.ServiceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends io.fabric8.knative.serving.v1.ServiceStatusFluentImpl<io.fabric8.knative.serving.v1beta1.ServiceFluent.StatusNested<N>> implements io.fabric8.knative.serving.v1beta1.ServiceFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.serving.v1.ServiceStatusBuilder builder;

            StatusNestedImpl(io.fabric8.knative.serving.v1.ServiceStatus item) {
                this.builder = new io.fabric8.knative.serving.v1.ServiceStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new io.fabric8.knative.serving.v1.ServiceStatusBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
