
package io.fabric8.knative.flows.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "address",
    "annotations",
    "branchStatuses",
    "conditions",
    "ingressChannelStatus",
    "observedGeneration"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class ParallelStatus implements KubernetesResource
{

    @JsonProperty("address")
    private Addressable address;
    @JsonProperty("annotations")
    private Map<String, String> annotations;
    @JsonProperty("branchStatuses")
    private List<ParallelBranchStatus> branchStatuses = new ArrayList<ParallelBranchStatus>();
    @JsonProperty("conditions")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<Condition> conditions = new ArrayList<Condition>();
    @JsonProperty("ingressChannelStatus")
    private ParallelChannelStatus ingressChannelStatus;
    @JsonProperty("observedGeneration")
    private Long observedGeneration;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ParallelStatus() {
    }

    /**
     * 
     * @param address
     * @param annotations
     * @param ingressChannelStatus
     * @param conditions
     * @param branchStatuses
     * @param observedGeneration
     */
    public ParallelStatus(Addressable address, Map<String, String> annotations, List<ParallelBranchStatus> branchStatuses, List<Condition> conditions, ParallelChannelStatus ingressChannelStatus, Long observedGeneration) {
        super();
        this.address = address;
        this.annotations = annotations;
        this.branchStatuses = branchStatuses;
        this.conditions = conditions;
        this.ingressChannelStatus = ingressChannelStatus;
        this.observedGeneration = observedGeneration;
    }

    @JsonProperty("address")
    public Addressable getAddress() {
        return address;
    }

    @JsonProperty("address")
    public void setAddress(Addressable address) {
        this.address = address;
    }

    @JsonProperty("annotations")
    public Map<String, String> getAnnotations() {
        return annotations;
    }

    @JsonProperty("annotations")
    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    @JsonProperty("branchStatuses")
    public List<ParallelBranchStatus> getBranchStatuses() {
        return branchStatuses;
    }

    @JsonProperty("branchStatuses")
    public void setBranchStatuses(List<ParallelBranchStatus> branchStatuses) {
        this.branchStatuses = branchStatuses;
    }

    @JsonProperty("conditions")
    public List<Condition> getConditions() {
        return conditions;
    }

    @JsonProperty("conditions")
    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    @JsonProperty("ingressChannelStatus")
    public ParallelChannelStatus getIngressChannelStatus() {
        return ingressChannelStatus;
    }

    @JsonProperty("ingressChannelStatus")
    public void setIngressChannelStatus(ParallelChannelStatus ingressChannelStatus) {
        this.ingressChannelStatus = ingressChannelStatus;
    }

    @JsonProperty("observedGeneration")
    public Long getObservedGeneration() {
        return observedGeneration;
    }

    @JsonProperty("observedGeneration")
    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
