package io.fabric8.knative.flows.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpec;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

public class ParallelSpecFluentImpl<A extends io.fabric8.knative.flows.v1.ParallelSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.flows.v1.ParallelSpecFluent<A> {

    private java.util.List<io.fabric8.knative.flows.v1.ParallelBranchBuilder> branches;
    private io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder channelTemplate;
    private io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder reply;

    public ParallelSpecFluentImpl() {
    }

    public ParallelSpecFluentImpl(io.fabric8.knative.flows.v1.ParallelSpec instance) {
        this.withBranches(instance.getBranches()); 
        this.withChannelTemplate(instance.getChannelTemplate()); 
        this.withReply(instance.getReply()); 
    }

    public A addToBranches(int index,io.fabric8.knative.flows.v1.ParallelBranch item) {
        if (this.branches == null) {this.branches = new java.util.ArrayList<io.fabric8.knative.flows.v1.ParallelBranchBuilder>();}
        io.fabric8.knative.flows.v1.ParallelBranchBuilder builder = new io.fabric8.knative.flows.v1.ParallelBranchBuilder(item);_visitables.get("branches").add(index >= 0 ? index : _visitables.get("branches").size(), builder);this.branches.add(index >= 0 ? index : branches.size(), builder); return (A)this;
    }

    public A setToBranches(int index,io.fabric8.knative.flows.v1.ParallelBranch item) {
        if (this.branches == null) {this.branches = new java.util.ArrayList<io.fabric8.knative.flows.v1.ParallelBranchBuilder>();}
        io.fabric8.knative.flows.v1.ParallelBranchBuilder builder = new io.fabric8.knative.flows.v1.ParallelBranchBuilder(item);
        if (index < 0 || index >= _visitables.get("branches").size()) { _visitables.get("branches").add(builder); } else { _visitables.get("branches").set(index, builder);}
        if (index < 0 || index >= branches.size()) { branches.add(builder); } else { branches.set(index, builder);}
         return (A)this;
    }

    public A addToBranches(io.fabric8.knative.flows.v1.ParallelBranch... items) {
        if (this.branches == null) {this.branches = new java.util.ArrayList<io.fabric8.knative.flows.v1.ParallelBranchBuilder>();}
        for (io.fabric8.knative.flows.v1.ParallelBranch item : items) {io.fabric8.knative.flows.v1.ParallelBranchBuilder builder = new io.fabric8.knative.flows.v1.ParallelBranchBuilder(item);_visitables.get("branches").add(builder);this.branches.add(builder);} return (A)this;
    }

    public A addAllToBranches(java.util.Collection<io.fabric8.knative.flows.v1.ParallelBranch> items) {
        if (this.branches == null) {this.branches = new java.util.ArrayList<io.fabric8.knative.flows.v1.ParallelBranchBuilder>();}
        for (io.fabric8.knative.flows.v1.ParallelBranch item : items) {io.fabric8.knative.flows.v1.ParallelBranchBuilder builder = new io.fabric8.knative.flows.v1.ParallelBranchBuilder(item);_visitables.get("branches").add(builder);this.branches.add(builder);} return (A)this;
    }

    public A removeFromBranches(io.fabric8.knative.flows.v1.ParallelBranch... items) {
        for (io.fabric8.knative.flows.v1.ParallelBranch item : items) {io.fabric8.knative.flows.v1.ParallelBranchBuilder builder = new io.fabric8.knative.flows.v1.ParallelBranchBuilder(item);_visitables.get("branches").remove(builder);if (this.branches != null) {this.branches.remove(builder);}} return (A)this;
    }

    public A removeAllFromBranches(java.util.Collection<io.fabric8.knative.flows.v1.ParallelBranch> items) {
        for (io.fabric8.knative.flows.v1.ParallelBranch item : items) {io.fabric8.knative.flows.v1.ParallelBranchBuilder builder = new io.fabric8.knative.flows.v1.ParallelBranchBuilder(item);_visitables.get("branches").remove(builder);if (this.branches != null) {this.branches.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBranches(java.util.function.Predicate<io.fabric8.knative.flows.v1.ParallelBranchBuilder> predicate) {
        if (branches == null) return (A) this;
        final Iterator<io.fabric8.knative.flows.v1.ParallelBranchBuilder> each = branches.iterator();
        final List visitables = _visitables.get("branches");
        while (each.hasNext()) {
          io.fabric8.knative.flows.v1.ParallelBranchBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBranches instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.knative.flows.v1.ParallelBranch> getBranches() {
        return build(branches);
    }

    public java.util.List<io.fabric8.knative.flows.v1.ParallelBranch> buildBranches() {
        return build(branches);
    }

    public io.fabric8.knative.flows.v1.ParallelBranch buildBranch(int index) {
        return this.branches.get(index).build();
    }

    public io.fabric8.knative.flows.v1.ParallelBranch buildFirstBranch() {
        return this.branches.get(0).build();
    }

    public io.fabric8.knative.flows.v1.ParallelBranch buildLastBranch() {
        return this.branches.get(branches.size() - 1).build();
    }

    public io.fabric8.knative.flows.v1.ParallelBranch buildMatchingBranch(java.util.function.Predicate<io.fabric8.knative.flows.v1.ParallelBranchBuilder> predicate) {
        for (io.fabric8.knative.flows.v1.ParallelBranchBuilder item: branches) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingBranch(java.util.function.Predicate<io.fabric8.knative.flows.v1.ParallelBranchBuilder> predicate) {
        for (io.fabric8.knative.flows.v1.ParallelBranchBuilder item: branches) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withBranches(java.util.List<io.fabric8.knative.flows.v1.ParallelBranch> branches) {
        if (this.branches != null) { _visitables.get("branches").removeAll(this.branches);}
        if (branches != null) {this.branches = new java.util.ArrayList<io.fabric8.knative.flows.v1.ParallelBranchBuilder>(); for (io.fabric8.knative.flows.v1.ParallelBranch item : branches){this.addToBranches(item);}} else { this.branches = null;} return (A) this;
    }

    public A withBranches(io.fabric8.knative.flows.v1.ParallelBranch... branches) {
        if (this.branches != null) {this.branches.clear();}
        if (branches != null) {for (io.fabric8.knative.flows.v1.ParallelBranch item :branches){ this.addToBranches(item);}} return (A) this;
    }

    public java.lang.Boolean hasBranches() {
        return branches != null && !branches.isEmpty();
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.BranchesNested<A> addNewBranch() {
        return new io.fabric8.knative.flows.v1.ParallelSpecFluentImpl.BranchesNestedImpl();
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.BranchesNested<A> addNewBranchLike(io.fabric8.knative.flows.v1.ParallelBranch item) {
        return new io.fabric8.knative.flows.v1.ParallelSpecFluentImpl.BranchesNestedImpl(-1, item);
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.BranchesNested<A> setNewBranchLike(int index,io.fabric8.knative.flows.v1.ParallelBranch item) {
        return new io.fabric8.knative.flows.v1.ParallelSpecFluentImpl.BranchesNestedImpl(index, item);
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.BranchesNested<A> editBranch(int index) {
        if (branches.size() <= index) throw new RuntimeException("Can't edit branches. Index exceeds size.");
        return setNewBranchLike(index, buildBranch(index));
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.BranchesNested<A> editFirstBranch() {
        if (branches.size() == 0) throw new RuntimeException("Can't edit first branches. The list is empty.");
        return setNewBranchLike(0, buildBranch(0));
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.BranchesNested<A> editLastBranch() {
        int index = branches.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last branches. The list is empty.");
        return setNewBranchLike(index, buildBranch(index));
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.BranchesNested<A> editMatchingBranch(java.util.function.Predicate<io.fabric8.knative.flows.v1.ParallelBranchBuilder> predicate) {
        int index = -1;
        for (int i=0;i<branches.size();i++) { 
        if (predicate.test(branches.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching branches. No match found.");
        return setNewBranchLike(index, buildBranch(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildChannelTemplate instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.messaging.v1.ChannelTemplateSpec getChannelTemplate() {
        return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public io.fabric8.knative.messaging.v1.ChannelTemplateSpec buildChannelTemplate() {
        return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public A withChannelTemplate(io.fabric8.knative.messaging.v1.ChannelTemplateSpec channelTemplate) {
        _visitables.get("channelTemplate").remove(this.channelTemplate);
        if (channelTemplate!=null){ this.channelTemplate= new io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder(channelTemplate); _visitables.get("channelTemplate").add(this.channelTemplate);} return (A) this;
    }

    public java.lang.Boolean hasChannelTemplate() {
        return this.channelTemplate != null;
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.ChannelTemplateNested<A> withNewChannelTemplate() {
        return new io.fabric8.knative.flows.v1.ParallelSpecFluentImpl.ChannelTemplateNestedImpl();
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.ChannelTemplateNested<A> withNewChannelTemplateLike(io.fabric8.knative.messaging.v1.ChannelTemplateSpec item) {
        return new io.fabric8.knative.flows.v1.ParallelSpecFluentImpl.ChannelTemplateNestedImpl(item);
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.ChannelTemplateNested<A> editChannelTemplate() {
        return withNewChannelTemplateLike(getChannelTemplate());
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplate() {
        return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): new io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder().build());
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplateLike(io.fabric8.knative.messaging.v1.ChannelTemplateSpec item) {
        return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReply instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.internal.pkg.apis.duck.v1.Destination getReply() {
        return this.reply!=null?this.reply.build():null;
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1.Destination buildReply() {
        return this.reply!=null?this.reply.build():null;
    }

    public A withReply(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination reply) {
        _visitables.get("reply").remove(this.reply);
        if (reply!=null){ this.reply= new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder(reply); _visitables.get("reply").add(this.reply);} return (A) this;
    }

    public java.lang.Boolean hasReply() {
        return this.reply != null;
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.ReplyNested<A> withNewReply() {
        return new io.fabric8.knative.flows.v1.ParallelSpecFluentImpl.ReplyNestedImpl();
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.ReplyNested<A> withNewReplyLike(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination item) {
        return new io.fabric8.knative.flows.v1.ParallelSpecFluentImpl.ReplyNestedImpl(item);
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.ReplyNested<A> editReply() {
        return withNewReplyLike(getReply());
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.ReplyNested<A> editOrNewReply() {
        return withNewReplyLike(getReply() != null ? getReply(): new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder().build());
    }

    public io.fabric8.knative.flows.v1.ParallelSpecFluent.ReplyNested<A> editOrNewReplyLike(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination item) {
        return withNewReplyLike(getReply() != null ? getReply(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ParallelSpecFluentImpl that = (ParallelSpecFluentImpl) o;
        if (branches != null ? !branches.equals(that.branches) :that.branches != null) return false;
        if (channelTemplate != null ? !channelTemplate.equals(that.channelTemplate) :that.channelTemplate != null) return false;
        if (reply != null ? !reply.equals(that.reply) :that.reply != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(branches,  channelTemplate,  reply,  super.hashCode());
    }

    public class BranchesNestedImpl<N> extends io.fabric8.knative.flows.v1.ParallelBranchFluentImpl<io.fabric8.knative.flows.v1.ParallelSpecFluent.BranchesNested<N>> implements io.fabric8.knative.flows.v1.ParallelSpecFluent.BranchesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.flows.v1.ParallelBranchBuilder builder;
        private final int index;

            BranchesNestedImpl(int index,io.fabric8.knative.flows.v1.ParallelBranch item) {
                this.index = index;
                this.builder = new io.fabric8.knative.flows.v1.ParallelBranchBuilder(this, item);
                        
            }

            BranchesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.knative.flows.v1.ParallelBranchBuilder(this);
                        
            }

            public N and() {
                return (N) ParallelSpecFluentImpl.this.setToBranches(index,builder.build());
            }

            public N endBranch() {
                return and();
            }
    }


    public class ChannelTemplateNestedImpl<N> extends io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluentImpl<io.fabric8.knative.flows.v1.ParallelSpecFluent.ChannelTemplateNested<N>> implements io.fabric8.knative.flows.v1.ParallelSpecFluent.ChannelTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder builder;

            ChannelTemplateNestedImpl(io.fabric8.knative.messaging.v1.ChannelTemplateSpec item) {
                this.builder = new io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder(this, item);
                        
            }

            ChannelTemplateNestedImpl() {
                this.builder = new io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder(this);
                        
            }

            public N and() {
                return (N) ParallelSpecFluentImpl.this.withChannelTemplate(builder.build());
            }

            public N endChannelTemplate() {
                return and();
            }
    }


    public class ReplyNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl<io.fabric8.knative.flows.v1.ParallelSpecFluent.ReplyNested<N>> implements io.fabric8.knative.flows.v1.ParallelSpecFluent.ReplyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder builder;

            ReplyNestedImpl(io.fabric8.knative.internal.pkg.apis.duck.v1.Destination item) {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder(this, item);
                        
            }

            ReplyNestedImpl() {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder(this);
                        
            }

            public N and() {
                return (N) ParallelSpecFluentImpl.this.withReply(builder.build());
            }

            public N endReply() {
                return and();
            }
    }


}
