package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusFluentImpl;
import java.lang.Deprecated;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluentImpl;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class InMemoryChannelStatusFluentImpl<A extends io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent<A> {

    private io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder address;
    private java.util.Map<java.lang.String,java.lang.String> annotations;
    private java.util.List<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> conditions;
    private io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder deadLetterChannel;
    private java.lang.Long observedGeneration;
    private java.util.List<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder> subscribers;

    public InMemoryChannelStatusFluentImpl() {
    }

    public InMemoryChannelStatusFluentImpl(io.fabric8.knative.messaging.v1.InMemoryChannelStatus instance) {
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withDeadLetterChannel(instance.getDeadLetterChannel()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSubscribers(instance.getSubscribers()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAddress instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable getAddress() {
        return this.address!=null?this.address.build():null;
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable buildAddress() {
        return this.address!=null?this.address.build():null;
    }

    public A withAddress(io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable address) {
        _visitables.get("address").remove(this.address);
        if (address!=null){ this.address= new io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public java.lang.Boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(java.lang.String url) {
        return (A)withAddress(new Addressable(url));
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.AddressNested<A> withNewAddress() {
        return new io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluentImpl.AddressNestedImpl();
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.AddressNested<A> withNewAddressLike(io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable item) {
        return new io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluentImpl.AddressNestedImpl(item);
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.AddressNested<A> editAddress() {
        return withNewAddressLike(getAddress());
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.AddressNested<A> editOrNewAddress() {
        return withNewAddressLike(getAddress() != null ? getAddress(): new io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder().build());
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.AddressNested<A> editOrNewAddressLike(io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable item) {
        return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A addToAnnotations(java.lang.String key,java.lang.String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null && map != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(java.lang.String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getAnnotations() {
        return this.annotations;
    }

    public <K,V>A withAnnotations(java.util.Map<java.lang.String,java.lang.String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(annotations);} return (A) this;
    }

    public java.lang.Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.knative.internal.pkg.apis.Condition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>();}
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.knative.internal.pkg.apis.Condition> items) {
        for (io.fabric8.knative.internal.pkg.apis.Condition item : items) {io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.knative.internal.pkg.apis.Condition buildMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        for (io.fabric8.knative.internal.pkg.apis.ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        for (io.fabric8.knative.internal.pkg.apis.ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.knative.internal.pkg.apis.Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.knative.internal.pkg.apis.ConditionBuilder>(); for (io.fabric8.knative.internal.pkg.apis.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.knative.internal.pkg.apis.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluentImpl.ConditionsNestedImpl();
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.knative.internal.pkg.apis.Condition item) {
        return new io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
        return new io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.knative.internal.pkg.apis.ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDeadLetterChannel instead.
     * @return The buildable object.
     */
        public io.fabric8.knative.internal.pkg.apis.duck.v1.KReference getDeadLetterChannel() {
        return this.deadLetterChannel!=null?this.deadLetterChannel.build():null;
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1.KReference buildDeadLetterChannel() {
        return this.deadLetterChannel!=null?this.deadLetterChannel.build():null;
    }

    public A withDeadLetterChannel(io.fabric8.knative.internal.pkg.apis.duck.v1.KReference deadLetterChannel) {
        _visitables.get("deadLetterChannel").remove(this.deadLetterChannel);
        if (deadLetterChannel!=null){ this.deadLetterChannel= new io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder(deadLetterChannel); _visitables.get("deadLetterChannel").add(this.deadLetterChannel);} return (A) this;
    }

    public java.lang.Boolean hasDeadLetterChannel() {
        return this.deadLetterChannel != null;
    }

    public A withNewDeadLetterChannel(java.lang.String apiVersion,java.lang.String kind,java.lang.String name,java.lang.String namespace) {
        return (A)withDeadLetterChannel(new KReference(apiVersion, kind, name, namespace));
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.DeadLetterChannelNested<A> withNewDeadLetterChannel() {
        return new io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluentImpl.DeadLetterChannelNestedImpl();
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.DeadLetterChannelNested<A> withNewDeadLetterChannelLike(io.fabric8.knative.internal.pkg.apis.duck.v1.KReference item) {
        return new io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluentImpl.DeadLetterChannelNestedImpl(item);
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.DeadLetterChannelNested<A> editDeadLetterChannel() {
        return withNewDeadLetterChannelLike(getDeadLetterChannel());
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.DeadLetterChannelNested<A> editOrNewDeadLetterChannel() {
        return withNewDeadLetterChannelLike(getDeadLetterChannel() != null ? getDeadLetterChannel(): new io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder().build());
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.DeadLetterChannelNested<A> editOrNewDeadLetterChannelLike(io.fabric8.knative.internal.pkg.apis.duck.v1.KReference item) {
        return withNewDeadLetterChannelLike(getDeadLetterChannel() != null ? getDeadLetterChannel(): item);
    }

    public java.lang.Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(java.lang.Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public java.lang.Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToSubscribers(int index,io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus item) {
        if (this.subscribers == null) {this.subscribers = new java.util.ArrayList<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder>();}
        io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder builder = new io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder(item);_visitables.get("subscribers").add(index >= 0 ? index : _visitables.get("subscribers").size(), builder);this.subscribers.add(index >= 0 ? index : subscribers.size(), builder); return (A)this;
    }

    public A setToSubscribers(int index,io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus item) {
        if (this.subscribers == null) {this.subscribers = new java.util.ArrayList<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder>();}
        io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder builder = new io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("subscribers").size()) { _visitables.get("subscribers").add(builder); } else { _visitables.get("subscribers").set(index, builder);}
        if (index < 0 || index >= subscribers.size()) { subscribers.add(builder); } else { subscribers.set(index, builder);}
         return (A)this;
    }

    public A addToSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus... items) {
        if (this.subscribers == null) {this.subscribers = new java.util.ArrayList<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder>();}
        for (io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus item : items) {io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder builder = new io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A addAllToSubscribers(java.util.Collection<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus> items) {
        if (this.subscribers == null) {this.subscribers = new java.util.ArrayList<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder>();}
        for (io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus item : items) {io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder builder = new io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A removeFromSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus... items) {
        for (io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus item : items) {io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder builder = new io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubscribers(java.util.Collection<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus> items) {
        for (io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus item : items) {io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder builder = new io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSubscribers(java.util.function.Predicate<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder> predicate) {
        if (subscribers == null) return (A) this;
        final Iterator<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder> each = subscribers.iterator();
        final List visitables = _visitables.get("subscribers");
        while (each.hasNext()) {
          io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSubscribers instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus> getSubscribers() {
        return build(subscribers);
    }

    public java.util.List<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus> buildSubscribers() {
        return build(subscribers);
    }

    public io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus buildSubscriber(int index) {
        return this.subscribers.get(index).build();
    }

    public io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus buildFirstSubscriber() {
        return this.subscribers.get(0).build();
    }

    public io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus buildLastSubscriber() {
        return this.subscribers.get(subscribers.size() - 1).build();
    }

    public io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus buildMatchingSubscriber(java.util.function.Predicate<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder> predicate) {
        for (io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder item: subscribers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingSubscriber(java.util.function.Predicate<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder> predicate) {
        for (io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder item: subscribers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSubscribers(java.util.List<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus> subscribers) {
        if (this.subscribers != null) { _visitables.get("subscribers").removeAll(this.subscribers);}
        if (subscribers != null) {this.subscribers = new java.util.ArrayList<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder>(); for (io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
    }

    public A withSubscribers(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus... subscribers) {
        if (this.subscribers != null) {this.subscribers.clear();}
        if (subscribers != null) {for (io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus item :subscribers){ this.addToSubscribers(item);}} return (A) this;
    }

    public java.lang.Boolean hasSubscribers() {
        return subscribers != null && !subscribers.isEmpty();
    }

    public A addNewSubscriber(java.lang.String message,java.lang.Long observedGeneration,java.lang.String ready,java.lang.String uid) {
        return (A)addToSubscribers(new SubscriberStatus(message, observedGeneration, ready, uid));
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.SubscribersNested<A> addNewSubscriber() {
        return new io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluentImpl.SubscribersNestedImpl();
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.SubscribersNested<A> addNewSubscriberLike(io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus item) {
        return new io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluentImpl.SubscribersNestedImpl(-1, item);
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.SubscribersNested<A> setNewSubscriberLike(int index,io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus item) {
        return new io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluentImpl.SubscribersNestedImpl(index, item);
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.SubscribersNested<A> editSubscriber(int index) {
        if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
        return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.SubscribersNested<A> editFirstSubscriber() {
        if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
        return setNewSubscriberLike(0, buildSubscriber(0));
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.SubscribersNested<A> editLastSubscriber() {
        int index = subscribers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
        return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.SubscribersNested<A> editMatchingSubscriber(java.util.function.Predicate<io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<subscribers.size();i++) { 
        if (predicate.test(subscribers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
        return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InMemoryChannelStatusFluentImpl that = (InMemoryChannelStatusFluentImpl) o;
        if (address != null ? !address.equals(that.address) :that.address != null) return false;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (deadLetterChannel != null ? !deadLetterChannel.equals(that.deadLetterChannel) :that.deadLetterChannel != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        if (subscribers != null ? !subscribers.equals(that.subscribers) :that.subscribers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(address,  annotations,  conditions,  deadLetterChannel,  observedGeneration,  subscribers,  super.hashCode());
    }

    public class AddressNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl<io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.AddressNested<N>> implements io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder builder;

            AddressNestedImpl(io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable item) {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder(this, item);
                        
            }

            AddressNestedImpl() {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder(this);
                        
            }

            public N and() {
                return (N) InMemoryChannelStatusFluentImpl.this.withAddress(builder.build());
            }

            public N endAddress() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl<io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.ConditionsNested<N>> implements io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.pkg.apis.ConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.knative.internal.pkg.apis.Condition item) {
                this.index = index;
                this.builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.knative.internal.pkg.apis.ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) InMemoryChannelStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class DeadLetterChannelNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluentImpl<io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.DeadLetterChannelNested<N>> implements io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.DeadLetterChannelNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder builder;

            DeadLetterChannelNestedImpl(io.fabric8.knative.internal.pkg.apis.duck.v1.KReference item) {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder(this, item);
                        
            }

            DeadLetterChannelNestedImpl() {
                this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) InMemoryChannelStatusFluentImpl.this.withDeadLetterChannel(builder.build());
            }

            public N endDeadLetterChannel() {
                return and();
            }
    }


    public class SubscribersNestedImpl<N> extends io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusFluentImpl<io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.SubscribersNested<N>> implements io.fabric8.knative.messaging.v1.InMemoryChannelStatusFluent.SubscribersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder builder;
        private final int index;

            SubscribersNestedImpl(int index,io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus item) {
                this.index = index;
                this.builder = new io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder(this, item);
                        
            }

            SubscribersNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder(this);
                        
            }

            public N and() {
                return (N) InMemoryChannelStatusFluentImpl.this.setToSubscribers(index,builder.build());
            }

            public N endSubscriber() {
                return and();
            }
    }


}
