package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KReferenceBuilder extends io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluentImpl<io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.internal.pkg.apis.duck.v1.KReference,io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder> {

    io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KReferenceBuilder() {
        this(true);
    }

    public KReferenceBuilder(java.lang.Boolean validationEnabled) {
        this(new KReference(), validationEnabled);
    }

    public KReferenceBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public KReferenceBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KReference(), validationEnabled);
    }

    public KReferenceBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluent<?> fluent,io.fabric8.knative.internal.pkg.apis.duck.v1.KReference instance) {
        this(fluent, instance, true);
    }

    public KReferenceBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluent<?> fluent,io.fabric8.knative.internal.pkg.apis.duck.v1.KReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public KReferenceBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.KReference instance) {
        this(instance,true);
    }

    public KReferenceBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.KReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1.EditableKReference build() {
        EditableKReference buildable = new EditableKReference(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KReferenceBuilder that = (KReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
