package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AddressableBuilder extends io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl<io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable,io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder> {

    io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public AddressableBuilder() {
        this(true);
    }

    public AddressableBuilder(java.lang.Boolean validationEnabled) {
        this(new Addressable(), validationEnabled);
    }

    public AddressableBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluent<?> fluent) {
        this(fluent, true);
    }

    public AddressableBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Addressable(), validationEnabled);
    }

    public AddressableBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluent<?> fluent,io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable instance) {
        this(fluent, instance, true);
    }

    public AddressableBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluent<?> fluent,io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }

    public AddressableBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable instance) {
        this(instance,true);
    }

    public AddressableBuilder(io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1.EditableAddressable build() {
        EditableAddressable buildable = new EditableAddressable(fluent.getUrl());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AddressableBuilder that = (AddressableBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
