package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaSourceSpecBuilder extends io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluentImpl<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpec,io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecBuilder> {

    io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaSourceSpecBuilder() {
        this(true);
    }

    public KafkaSourceSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaSourceSpec(), validationEnabled);
    }

    public KafkaSourceSpecBuilder(io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaSourceSpecBuilder(io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaSourceSpec(), validationEnabled);
    }

    public KafkaSourceSpecBuilder(io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent<?> fluent,io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaSourceSpecBuilder(io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent<?> fluent,io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBootstrapServers(instance.getBootstrapServers()); 
        fluent.withCeOverrides(instance.getCeOverrides()); 
        fluent.withConsumerGroup(instance.getConsumerGroup()); 
        fluent.withNet(instance.getNet()); 
        fluent.withSink(instance.getSink()); 
        fluent.withTopics(instance.getTopics()); 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaSourceSpecBuilder(io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpec instance) {
        this(instance,true);
    }

    public KafkaSourceSpecBuilder(io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBootstrapServers(instance.getBootstrapServers()); 
        this.withCeOverrides(instance.getCeOverrides()); 
        this.withConsumerGroup(instance.getConsumerGroup()); 
        this.withNet(instance.getNet()); 
        this.withSink(instance.getSink()); 
        this.withTopics(instance.getTopics()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.contrib.kafka.v1beta1.EditableKafkaSourceSpec build() {
        EditableKafkaSourceSpec buildable = new EditableKafkaSourceSpec(fluent.getBootstrapServers(),fluent.getCeOverrides(),fluent.getConsumerGroup(),fluent.getNet(),fluent.getSink(),fluent.getTopics());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaSourceSpecBuilder that = (KafkaSourceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
