package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InMemoryChannelSpecBuilder extends io.fabric8.knative.messaging.v1.InMemoryChannelSpecFluentImpl<io.fabric8.knative.messaging.v1.InMemoryChannelSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.knative.messaging.v1.InMemoryChannelSpec,io.fabric8.knative.messaging.v1.InMemoryChannelSpecBuilder> {

    io.fabric8.knative.messaging.v1.InMemoryChannelSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public InMemoryChannelSpecBuilder() {
        this(true);
    }

    public InMemoryChannelSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new InMemoryChannelSpec(), validationEnabled);
    }

    public InMemoryChannelSpecBuilder(io.fabric8.knative.messaging.v1.InMemoryChannelSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public InMemoryChannelSpecBuilder(io.fabric8.knative.messaging.v1.InMemoryChannelSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new InMemoryChannelSpec(), validationEnabled);
    }

    public InMemoryChannelSpecBuilder(io.fabric8.knative.messaging.v1.InMemoryChannelSpecFluent<?> fluent,io.fabric8.knative.messaging.v1.InMemoryChannelSpec instance) {
        this(fluent, instance, true);
    }

    public InMemoryChannelSpecBuilder(io.fabric8.knative.messaging.v1.InMemoryChannelSpecFluent<?> fluent,io.fabric8.knative.messaging.v1.InMemoryChannelSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDelivery(instance.getDelivery()); 
        fluent.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }

    public InMemoryChannelSpecBuilder(io.fabric8.knative.messaging.v1.InMemoryChannelSpec instance) {
        this(instance,true);
    }

    public InMemoryChannelSpecBuilder(io.fabric8.knative.messaging.v1.InMemoryChannelSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDelivery(instance.getDelivery()); 
        this.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.messaging.v1.EditableInMemoryChannelSpec build() {
        EditableInMemoryChannelSpec buildable = new EditableInMemoryChannelSpec(fluent.getDelivery(),fluent.getSubscribers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InMemoryChannelSpecBuilder that = (InMemoryChannelSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
