
package io.fabric8.knative.flows.v1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "filterChannelStatus",
    "filterSubscriptionStatus",
    "subscriberSubscriptionStatus"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class ParallelBranchStatus implements KubernetesResource
{

    @JsonProperty("filterChannelStatus")
    private ParallelChannelStatus filterChannelStatus;
    @JsonProperty("filterSubscriptionStatus")
    private ParallelSubscriptionStatus filterSubscriptionStatus;
    @JsonProperty("subscriberSubscriptionStatus")
    private ParallelSubscriptionStatus subscriberSubscriptionStatus;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ParallelBranchStatus() {
    }

    /**
     * 
     * @param filterChannelStatus
     * @param filterSubscriptionStatus
     * @param subscriberSubscriptionStatus
     */
    public ParallelBranchStatus(ParallelChannelStatus filterChannelStatus, ParallelSubscriptionStatus filterSubscriptionStatus, ParallelSubscriptionStatus subscriberSubscriptionStatus) {
        super();
        this.filterChannelStatus = filterChannelStatus;
        this.filterSubscriptionStatus = filterSubscriptionStatus;
        this.subscriberSubscriptionStatus = subscriberSubscriptionStatus;
    }

    @JsonProperty("filterChannelStatus")
    public ParallelChannelStatus getFilterChannelStatus() {
        return filterChannelStatus;
    }

    @JsonProperty("filterChannelStatus")
    public void setFilterChannelStatus(ParallelChannelStatus filterChannelStatus) {
        this.filterChannelStatus = filterChannelStatus;
    }

    @JsonProperty("filterSubscriptionStatus")
    public ParallelSubscriptionStatus getFilterSubscriptionStatus() {
        return filterSubscriptionStatus;
    }

    @JsonProperty("filterSubscriptionStatus")
    public void setFilterSubscriptionStatus(ParallelSubscriptionStatus filterSubscriptionStatus) {
        this.filterSubscriptionStatus = filterSubscriptionStatus;
    }

    @JsonProperty("subscriberSubscriptionStatus")
    public ParallelSubscriptionStatus getSubscriberSubscriptionStatus() {
        return subscriberSubscriptionStatus;
    }

    @JsonProperty("subscriberSubscriptionStatus")
    public void setSubscriberSubscriptionStatus(ParallelSubscriptionStatus subscriberSubscriptionStatus) {
        this.subscriberSubscriptionStatus = subscriberSubscriptionStatus;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
