package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitLabSourceStatusBuilder extends GitLabSourceStatusFluentImpl<GitLabSourceStatusBuilder> implements VisitableBuilder<GitLabSourceStatus,GitLabSourceStatusBuilder>{
  public GitLabSourceStatusBuilder() {
    this(false);
  }
  public GitLabSourceStatusBuilder(Boolean validationEnabled) {
    this(new GitLabSourceStatus(), validationEnabled);
  }
  public GitLabSourceStatusBuilder(GitLabSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public GitLabSourceStatusBuilder(GitLabSourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitLabSourceStatus(), validationEnabled);
  }
  public GitLabSourceStatusBuilder(GitLabSourceStatusFluent<?> fluent,GitLabSourceStatus instance) {
    this(fluent, instance, false);
  }
  public GitLabSourceStatusBuilder(GitLabSourceStatusFluent<?> fluent,GitLabSourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withId(instance.getId()); 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withCeAttributes(instance.getCeAttributes()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withSinkUri(instance.getSinkUri()); 
    this.validationEnabled = validationEnabled; 
  }
  public GitLabSourceStatusBuilder(GitLabSourceStatus instance) {
    this(instance,false);
  }
  public GitLabSourceStatusBuilder(GitLabSourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withId(instance.getId()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withCeAttributes(instance.getCeAttributes()); 
    this.withConditions(instance.getConditions()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withSinkUri(instance.getSinkUri()); 
    this.validationEnabled = validationEnabled; 
  }
  GitLabSourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public GitLabSourceStatus build() {
    GitLabSourceStatus buildable = new GitLabSourceStatus(fluent.getId(),fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
    return buildable;
  }
  
}