package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaChannelSpecBuilder extends KafkaChannelSpecFluentImpl<KafkaChannelSpecBuilder> implements VisitableBuilder<KafkaChannelSpec,KafkaChannelSpecBuilder>{
  public KafkaChannelSpecBuilder() {
    this(false);
  }
  public KafkaChannelSpecBuilder(Boolean validationEnabled) {
    this(new KafkaChannelSpec(), validationEnabled);
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaChannelSpec(), validationEnabled);
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpecFluent<?> fluent,KafkaChannelSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpecFluent<?> fluent,KafkaChannelSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDelivery(instance.getDelivery()); 
    fluent.withNumPartitions(instance.getNumPartitions()); 
    fluent.withReplicationFactor(instance.getReplicationFactor()); 
    fluent.withSubscribers(instance.getSubscribers()); 
    this.validationEnabled = validationEnabled; 
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpec instance) {
    this(instance,false);
  }
  public KafkaChannelSpecBuilder(KafkaChannelSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDelivery(instance.getDelivery()); 
    this.withNumPartitions(instance.getNumPartitions()); 
    this.withReplicationFactor(instance.getReplicationFactor()); 
    this.withSubscribers(instance.getSubscribers()); 
    this.validationEnabled = validationEnabled; 
  }
  KafkaChannelSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaChannelSpec build() {
    KafkaChannelSpec buildable = new KafkaChannelSpec(fluent.getDelivery(),fluent.getNumPartitions(),fluent.getReplicationFactor(),fluent.getSubscribers());
    return buildable;
  }
  
}