package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaSourceSpecBuilder extends KafkaSourceSpecFluentImpl<KafkaSourceSpecBuilder> implements VisitableBuilder<KafkaSourceSpec,KafkaSourceSpecBuilder>{
  public KafkaSourceSpecBuilder() {
    this(false);
  }
  public KafkaSourceSpecBuilder(Boolean validationEnabled) {
    this(new KafkaSourceSpec(), validationEnabled);
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaSourceSpec(), validationEnabled);
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent,KafkaSourceSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent,KafkaSourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBootstrapServers(instance.getBootstrapServers()); 
    fluent.withCeOverrides(instance.getCeOverrides()); 
    fluent.withConsumerGroup(instance.getConsumerGroup()); 
    fluent.withNet(instance.getNet()); 
    fluent.withSink(instance.getSink()); 
    fluent.withTopics(instance.getTopics()); 
    this.validationEnabled = validationEnabled; 
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpec instance) {
    this(instance,false);
  }
  public KafkaSourceSpecBuilder(KafkaSourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBootstrapServers(instance.getBootstrapServers()); 
    this.withCeOverrides(instance.getCeOverrides()); 
    this.withConsumerGroup(instance.getConsumerGroup()); 
    this.withNet(instance.getNet()); 
    this.withSink(instance.getSink()); 
    this.withTopics(instance.getTopics()); 
    this.validationEnabled = validationEnabled; 
  }
  KafkaSourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaSourceSpec build() {
    KafkaSourceSpec buildable = new KafkaSourceSpec(fluent.getBootstrapServers(),fluent.getCeOverrides(),fluent.getConsumerGroup(),fluent.getNet(),fluent.getSink(),fluent.getTopics());
    return buildable;
  }
  
}