package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerSpecBuilder extends TriggerSpecFluentImpl<TriggerSpecBuilder> implements VisitableBuilder<TriggerSpec,TriggerSpecBuilder>{
  public TriggerSpecBuilder() {
    this(false);
  }
  public TriggerSpecBuilder(Boolean validationEnabled) {
    this(new TriggerSpec(), validationEnabled);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerSpec(), validationEnabled);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,TriggerSpec instance) {
    this(fluent, instance, false);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,TriggerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBroker(instance.getBroker()); 
    fluent.withDelivery(instance.getDelivery()); 
    fluent.withFilter(instance.getFilter()); 
    fluent.withSubscriber(instance.getSubscriber()); 
    this.validationEnabled = validationEnabled; 
  }
  public TriggerSpecBuilder(TriggerSpec instance) {
    this(instance,false);
  }
  public TriggerSpecBuilder(TriggerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBroker(instance.getBroker()); 
    this.withDelivery(instance.getDelivery()); 
    this.withFilter(instance.getFilter()); 
    this.withSubscriber(instance.getSubscriber()); 
    this.validationEnabled = validationEnabled; 
  }
  TriggerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerSpec build() {
    TriggerSpec buildable = new TriggerSpec(fluent.getBroker(),fluent.getDelivery(),fluent.getFilter(),fluent.getSubscriber());
    return buildable;
  }
  
}