package io.fabric8.knative.eventing.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import java.lang.SuppressWarnings;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TriggerSpecFluentImpl<A extends TriggerSpecFluent<A>> extends BaseFluent<A> implements TriggerSpecFluent<A>{
  public TriggerSpecFluentImpl() {
  }
  public TriggerSpecFluentImpl(TriggerSpec instance) {
    this.withBroker(instance.getBroker()); 
    this.withDelivery(instance.getDelivery()); 
    this.withFilter(instance.getFilter()); 
    this.withSubscriber(instance.getSubscriber()); 
  }
  private String broker;
  private DeliverySpecBuilder delivery;
  private TriggerFilterBuilder filter;
  private DestinationBuilder subscriber;
  public String getBroker() {
    return this.broker;
  }
  public A withBroker(String broker) {
    this.broker=broker; return (A) this;
  }
  public Boolean hasBroker() {
    return this.broker != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDelivery instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeliverySpec getDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  public DeliverySpec buildDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  public A withDelivery(DeliverySpec delivery) {
    _visitables.get("delivery").remove(this.delivery);
    if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} else { this.delivery = null; _visitables.get("delivery").remove(this.delivery); } return (A) this;
  }
  public Boolean hasDelivery() {
    return this.delivery != null;
  }
  public TriggerSpecFluent.DeliveryNested<A> withNewDelivery() {
    return new TriggerSpecFluentImpl.DeliveryNestedImpl();
  }
  public TriggerSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new TriggerSpecFluentImpl.DeliveryNestedImpl(item);
  }
  public TriggerSpecFluent.DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(getDelivery());
  }
  public TriggerSpecFluent.DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
  }
  public TriggerSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFilter instead.
   * @return The buildable object.
   */
  @Deprecated
  public TriggerFilter getFilter() {
    return this.filter!=null ?this.filter.build():null;
  }
  public TriggerFilter buildFilter() {
    return this.filter!=null ?this.filter.build():null;
  }
  public A withFilter(TriggerFilter filter) {
    _visitables.get("filter").remove(this.filter);
    if (filter!=null){ this.filter= new TriggerFilterBuilder(filter); _visitables.get("filter").add(this.filter);} else { this.filter = null; _visitables.get("filter").remove(this.filter); } return (A) this;
  }
  public Boolean hasFilter() {
    return this.filter != null;
  }
  public TriggerSpecFluent.FilterNested<A> withNewFilter() {
    return new TriggerSpecFluentImpl.FilterNestedImpl();
  }
  public TriggerSpecFluent.FilterNested<A> withNewFilterLike(TriggerFilter item) {
    return new TriggerSpecFluentImpl.FilterNestedImpl(item);
  }
  public TriggerSpecFluent.FilterNested<A> editFilter() {
    return withNewFilterLike(getFilter());
  }
  public TriggerSpecFluent.FilterNested<A> editOrNewFilter() {
    return withNewFilterLike(getFilter() != null ? getFilter(): new TriggerFilterBuilder().build());
  }
  public TriggerSpecFluent.FilterNested<A> editOrNewFilterLike(TriggerFilter item) {
    return withNewFilterLike(getFilter() != null ? getFilter(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSubscriber instead.
   * @return The buildable object.
   */
  @Deprecated
  public Destination getSubscriber() {
    return this.subscriber!=null ?this.subscriber.build():null;
  }
  public Destination buildSubscriber() {
    return this.subscriber!=null ?this.subscriber.build():null;
  }
  public A withSubscriber(Destination subscriber) {
    _visitables.get("subscriber").remove(this.subscriber);
    if (subscriber!=null){ this.subscriber= new DestinationBuilder(subscriber); _visitables.get("subscriber").add(this.subscriber);} else { this.subscriber = null; _visitables.get("subscriber").remove(this.subscriber); } return (A) this;
  }
  public Boolean hasSubscriber() {
    return this.subscriber != null;
  }
  public TriggerSpecFluent.SubscriberNested<A> withNewSubscriber() {
    return new TriggerSpecFluentImpl.SubscriberNestedImpl();
  }
  public TriggerSpecFluent.SubscriberNested<A> withNewSubscriberLike(Destination item) {
    return new TriggerSpecFluentImpl.SubscriberNestedImpl(item);
  }
  public TriggerSpecFluent.SubscriberNested<A> editSubscriber() {
    return withNewSubscriberLike(getSubscriber());
  }
  public TriggerSpecFluent.SubscriberNested<A> editOrNewSubscriber() {
    return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): new DestinationBuilder().build());
  }
  public TriggerSpecFluent.SubscriberNested<A> editOrNewSubscriberLike(Destination item) {
    return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TriggerSpecFluentImpl that = (TriggerSpecFluentImpl) o;
    if (broker != null ? !broker.equals(that.broker) :that.broker != null) return false;
    if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
    if (filter != null ? !filter.equals(that.filter) :that.filter != null) return false;
    if (subscriber != null ? !subscriber.equals(that.subscriber) :that.subscriber != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(broker,  delivery,  filter,  subscriber,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (broker != null) { sb.append("broker:"); sb.append(broker + ","); }
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (filter != null) { sb.append("filter:"); sb.append(filter + ","); }
    if (subscriber != null) { sb.append("subscriber:"); sb.append(subscriber); }
    sb.append("}");
    return sb.toString();
  }
  class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<TriggerSpecFluent.DeliveryNested<N>> implements TriggerSpecFluent.DeliveryNested<N>,Nested<N>{
    DeliveryNestedImpl(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliveryNestedImpl() {
      this.builder = new DeliverySpecBuilder(this);
    }
    DeliverySpecBuilder builder;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.withDelivery(builder.build());
    }
    public N endDelivery() {
      return and();
    }
    
  }
  class FilterNestedImpl<N> extends TriggerFilterFluentImpl<TriggerSpecFluent.FilterNested<N>> implements TriggerSpecFluent.FilterNested<N>,Nested<N>{
    FilterNestedImpl(TriggerFilter item) {
      this.builder = new TriggerFilterBuilder(this, item);
    }
    FilterNestedImpl() {
      this.builder = new TriggerFilterBuilder(this);
    }
    TriggerFilterBuilder builder;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.withFilter(builder.build());
    }
    public N endFilter() {
      return and();
    }
    
  }
  class SubscriberNestedImpl<N> extends DestinationFluentImpl<TriggerSpecFluent.SubscriberNested<N>> implements TriggerSpecFluent.SubscriberNested<N>,Nested<N>{
    SubscriberNestedImpl(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    SubscriberNestedImpl() {
      this.builder = new DestinationBuilder(this);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.withSubscriber(builder.build());
    }
    public N endSubscriber() {
      return and();
    }
    
  }
  
}