package io.fabric8.knative.internal.eventing.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeliverySpecBuilder extends DeliverySpecFluentImpl<DeliverySpecBuilder> implements VisitableBuilder<DeliverySpec,DeliverySpecBuilder>{
  public DeliverySpecBuilder() {
    this(false);
  }
  public DeliverySpecBuilder(Boolean validationEnabled) {
    this(new DeliverySpec(), validationEnabled);
  }
  public DeliverySpecBuilder(DeliverySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DeliverySpecBuilder(DeliverySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeliverySpec(), validationEnabled);
  }
  public DeliverySpecBuilder(DeliverySpecFluent<?> fluent,DeliverySpec instance) {
    this(fluent, instance, false);
  }
  public DeliverySpecBuilder(DeliverySpecFluent<?> fluent,DeliverySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBackoffDelay(instance.getBackoffDelay()); 
    fluent.withBackoffPolicy(instance.getBackoffPolicy()); 
    fluent.withDeadLetterSink(instance.getDeadLetterSink()); 
    fluent.withRetry(instance.getRetry()); 
    this.validationEnabled = validationEnabled; 
  }
  public DeliverySpecBuilder(DeliverySpec instance) {
    this(instance,false);
  }
  public DeliverySpecBuilder(DeliverySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBackoffDelay(instance.getBackoffDelay()); 
    this.withBackoffPolicy(instance.getBackoffPolicy()); 
    this.withDeadLetterSink(instance.getDeadLetterSink()); 
    this.withRetry(instance.getRetry()); 
    this.validationEnabled = validationEnabled; 
  }
  DeliverySpecFluent<?> fluent;
  Boolean validationEnabled;
  public DeliverySpec build() {
    DeliverySpec buildable = new DeliverySpec(fluent.getBackoffDelay(),fluent.getBackoffPolicy(),fluent.getDeadLetterSink(),fluent.getRetry());
    return buildable;
  }
  
}