package io.fabric8.knative.internal.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KReferenceBuilder extends KReferenceFluentImpl<KReferenceBuilder> implements VisitableBuilder<KReference,KReferenceBuilder>{
  public KReferenceBuilder() {
    this(false);
  }
  public KReferenceBuilder(Boolean validationEnabled) {
    this(new KReference(), validationEnabled);
  }
  public KReferenceBuilder(KReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public KReferenceBuilder(KReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KReference(), validationEnabled);
  }
  public KReferenceBuilder(KReferenceFluent<?> fluent,KReference instance) {
    this(fluent, instance, false);
  }
  public KReferenceBuilder(KReferenceFluent<?> fluent,KReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    this.validationEnabled = validationEnabled; 
  }
  public KReferenceBuilder(KReference instance) {
    this(instance,false);
  }
  public KReferenceBuilder(KReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.validationEnabled = validationEnabled; 
  }
  KReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public KReference build() {
    KReference buildable = new KReference(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
    return buildable;
  }
  
}