package io.fabric8.knative.serving.v1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface RevisionStatusFluent<A extends RevisionStatusFluent<A>> extends Fluent<A>{
  public Integer getActualReplicas();
  public A withActualReplicas(Integer actualReplicas);
  public Boolean hasActualReplicas();
  public A addToAnnotations(String key,String value);
  public A addToAnnotations(Map<String,String> map);
  public A removeFromAnnotations(String key);
  public A removeFromAnnotations(Map<String,String> map);
  public Map<String,String> getAnnotations();
  public <K,V>A withAnnotations(Map<String,String> annotations);
  public Boolean hasAnnotations();
  public A addToConditions(Integer index,Condition item);
  public A setToConditions(Integer index,Condition item);
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items);
  public A addAllToConditions(Collection<Condition> items);
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items);
  public A removeAllFromConditions(Collection<Condition> items);
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions();
  public List<Condition> buildConditions();
  public Condition buildCondition(Integer index);
  public Condition buildFirstCondition();
  public Condition buildLastCondition();
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate);
  public A withConditions(List<Condition> conditions);
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions);
  public Boolean hasConditions();
  public RevisionStatusFluent.ConditionsNested<A> addNewCondition();
  public RevisionStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item);
  public RevisionStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,Condition item);
  public RevisionStatusFluent.ConditionsNested<A> editCondition(Integer index);
  public RevisionStatusFluent.ConditionsNested<A> editFirstCondition();
  public RevisionStatusFluent.ConditionsNested<A> editLastCondition();
  public RevisionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate);
  public A addToContainerStatuses(Integer index,ContainerStatus item);
  public A setToContainerStatuses(Integer index,ContainerStatus item);
  public A addToContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items);
  public A addAllToContainerStatuses(Collection<ContainerStatus> items);
  public A removeFromContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items);
  public A removeAllFromContainerStatuses(Collection<ContainerStatus> items);
  public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildContainerStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerStatus> getContainerStatuses();
  public List<ContainerStatus> buildContainerStatuses();
  public ContainerStatus buildContainerStatus(Integer index);
  public ContainerStatus buildFirstContainerStatus();
  public ContainerStatus buildLastContainerStatus();
  public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public Boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public A withContainerStatuses(List<ContainerStatus> containerStatuses);
  public A withContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... containerStatuses);
  public Boolean hasContainerStatuses();
  public A addNewContainerStatus(String imageDigest,String name);
  public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatus();
  public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item);
  public RevisionStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(Integer index,ContainerStatus item);
  public RevisionStatusFluent.ContainerStatusesNested<A> editContainerStatus(Integer index);
  public RevisionStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus();
  public RevisionStatusFluent.ContainerStatusesNested<A> editLastContainerStatus();
  public RevisionStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate);
  public Integer getDesiredReplicas();
  public A withDesiredReplicas(Integer desiredReplicas);
  public Boolean hasDesiredReplicas();
  public String getImageDigest();
  public A withImageDigest(String imageDigest);
  public Boolean hasImageDigest();
  public String getLogUrl();
  public A withLogUrl(String logUrl);
  public Boolean hasLogUrl();
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public String getServiceName();
  public A withServiceName(String serviceName);
  public Boolean hasServiceName();
  public interface ConditionsNested<N> extends Nested<N>,ConditionFluent<RevisionStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface ContainerStatusesNested<N> extends Nested<N>,ContainerStatusFluent<RevisionStatusFluent.ContainerStatusesNested<N>>{
    public N and();
    public N endContainerStatus();
    
  }
  
}