package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import java.lang.Integer;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RevisionStatusFluentImpl<A extends RevisionStatusFluent<A>> extends BaseFluent<A> implements RevisionStatusFluent<A>{
  public RevisionStatusFluentImpl() {
  }
  public RevisionStatusFluentImpl(RevisionStatus instance) {
    this.withActualReplicas(instance.getActualReplicas()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withConditions(instance.getConditions()); 
    this.withContainerStatuses(instance.getContainerStatuses()); 
    this.withDesiredReplicas(instance.getDesiredReplicas()); 
    this.withImageDigest(instance.getImageDigest()); 
    this.withLogUrl(instance.getLogUrl()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withServiceName(instance.getServiceName()); 
  }
  private Integer actualReplicas;
  private Map<String,String> annotations;
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private ArrayList<ContainerStatusBuilder> containerStatuses = new ArrayList<ContainerStatusBuilder>();
  private Integer desiredReplicas;
  private String imageDigest;
  private String logUrl;
  private Long observedGeneration;
  private String serviceName;
  public Integer getActualReplicas() {
    return this.actualReplicas;
  }
  public A withActualReplicas(Integer actualReplicas) {
    this.actualReplicas=actualReplicas; return (A) this;
  }
  public Boolean hasActualReplicas() {
    return this.actualReplicas != null;
  }
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public RevisionStatusFluent.ConditionsNested<A> addNewCondition() {
    return new RevisionStatusFluentImpl.ConditionsNestedImpl();
  }
  public RevisionStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
    return new RevisionStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public RevisionStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,Condition item) {
    return new RevisionStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public RevisionStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public RevisionStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public RevisionStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public RevisionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToContainerStatuses(Integer index,ContainerStatus item) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(index >= 0 ? index : _visitables.get("containerStatuses").size(), builder);this.containerStatuses.add(index >= 0 ? index : containerStatuses.size(), builder); return (A)this;
  }
  public A setToContainerStatuses(Integer index,ContainerStatus item) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("containerStatuses").size()) { _visitables.get("containerStatuses").add(builder); } else { _visitables.get("containerStatuses").set(index, builder);}
    if (index < 0 || index >= containerStatuses.size()) { containerStatuses.add(builder); } else { containerStatuses.set(index, builder);}
     return (A)this;
  }
  public A addToContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
  }
  public A addAllToContainerStatuses(Collection<ContainerStatus> items) {
    if (this.containerStatuses == null) {this.containerStatuses = new ArrayList<ContainerStatusBuilder>();}
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").add(builder);this.containerStatuses.add(builder);} return (A)this;
  }
  public A removeFromContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainerStatuses(Collection<ContainerStatus> items) {
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.get("containerStatuses").remove(builder);if (this.containerStatuses != null) {this.containerStatuses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
    if (containerStatuses == null) return (A) this;
    final Iterator<ContainerStatusBuilder> each = containerStatuses.iterator();
    final List visitables = _visitables.get("containerStatuses");
    while (each.hasNext()) {
      ContainerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainerStatuses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerStatus> getContainerStatuses() {
    return containerStatuses != null ? build(containerStatuses) : null;
  }
  public List<ContainerStatus> buildContainerStatuses() {
    return containerStatuses != null ? build(containerStatuses) : null;
  }
  public ContainerStatus buildContainerStatus(Integer index) {
    return this.containerStatuses.get(index).build();
  }
  public ContainerStatus buildFirstContainerStatus() {
    return this.containerStatuses.get(0).build();
  }
  public ContainerStatus buildLastContainerStatus() {
    return this.containerStatuses.get(containerStatuses.size() - 1).build();
  }
  public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: containerStatuses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    for (ContainerStatusBuilder item: containerStatuses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
    if (this.containerStatuses != null) { _visitables.get("containerStatuses").removeAll(this.containerStatuses);}
    if (containerStatuses != null) {this.containerStatuses = new ArrayList(); for (ContainerStatus item : containerStatuses){this.addToContainerStatuses(item);}} else { this.containerStatuses = null;} return (A) this;
  }
  public A withContainerStatuses(io.fabric8.knative.serving.v1.ContainerStatus... containerStatuses) {
    if (this.containerStatuses != null) {this.containerStatuses.clear();}
    if (containerStatuses != null) {for (ContainerStatus item :containerStatuses){ this.addToContainerStatuses(item);}} return (A) this;
  }
  public Boolean hasContainerStatuses() {
    return containerStatuses != null && !containerStatuses.isEmpty();
  }
  public A addNewContainerStatus(String imageDigest,String name) {
    return (A)addToContainerStatuses(new ContainerStatus(imageDigest, name));
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
    return new RevisionStatusFluentImpl.ContainerStatusesNestedImpl();
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
    return new RevisionStatusFluentImpl.ContainerStatusesNestedImpl(-1, item);
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(Integer index,ContainerStatus item) {
    return new RevisionStatusFluentImpl.ContainerStatusesNestedImpl(index, item);
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> editContainerStatus(Integer index) {
    if (containerStatuses.size() <= index) throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
    if (containerStatuses.size() == 0) throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
    return setNewContainerStatusLike(0, buildContainerStatus(0));
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
    int index = containerStatuses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public RevisionStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containerStatuses.size();i++) { 
    if (predicate.test(containerStatuses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
    return setNewContainerStatusLike(index, buildContainerStatus(index));
  }
  public Integer getDesiredReplicas() {
    return this.desiredReplicas;
  }
  public A withDesiredReplicas(Integer desiredReplicas) {
    this.desiredReplicas=desiredReplicas; return (A) this;
  }
  public Boolean hasDesiredReplicas() {
    return this.desiredReplicas != null;
  }
  public String getImageDigest() {
    return this.imageDigest;
  }
  public A withImageDigest(String imageDigest) {
    this.imageDigest=imageDigest; return (A) this;
  }
  public Boolean hasImageDigest() {
    return this.imageDigest != null;
  }
  public String getLogUrl() {
    return this.logUrl;
  }
  public A withLogUrl(String logUrl) {
    this.logUrl=logUrl; return (A) this;
  }
  public Boolean hasLogUrl() {
    return this.logUrl != null;
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public String getServiceName() {
    return this.serviceName;
  }
  public A withServiceName(String serviceName) {
    this.serviceName=serviceName; return (A) this;
  }
  public Boolean hasServiceName() {
    return this.serviceName != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RevisionStatusFluentImpl that = (RevisionStatusFluentImpl) o;
    if (actualReplicas != null ? !actualReplicas.equals(that.actualReplicas) :that.actualReplicas != null) return false;
    if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (containerStatuses != null ? !containerStatuses.equals(that.containerStatuses) :that.containerStatuses != null) return false;
    if (desiredReplicas != null ? !desiredReplicas.equals(that.desiredReplicas) :that.desiredReplicas != null) return false;
    if (imageDigest != null ? !imageDigest.equals(that.imageDigest) :that.imageDigest != null) return false;
    if (logUrl != null ? !logUrl.equals(that.logUrl) :that.logUrl != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(actualReplicas,  annotations,  conditions,  containerStatuses,  desiredReplicas,  imageDigest,  logUrl,  observedGeneration,  serviceName,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (actualReplicas != null) { sb.append("actualReplicas:"); sb.append(actualReplicas + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (containerStatuses != null && !containerStatuses.isEmpty()) { sb.append("containerStatuses:"); sb.append(containerStatuses + ","); }
    if (desiredReplicas != null) { sb.append("desiredReplicas:"); sb.append(desiredReplicas + ","); }
    if (imageDigest != null) { sb.append("imageDigest:"); sb.append(imageDigest + ","); }
    if (logUrl != null) { sb.append("logUrl:"); sb.append(logUrl + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (serviceName != null) { sb.append("serviceName:"); sb.append(serviceName); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ConditionFluentImpl<RevisionStatusFluent.ConditionsNested<N>> implements RevisionStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) RevisionStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ContainerStatusesNestedImpl<N> extends ContainerStatusFluentImpl<RevisionStatusFluent.ContainerStatusesNested<N>> implements RevisionStatusFluent.ContainerStatusesNested<N>,Nested<N>{
    ContainerStatusesNestedImpl(Integer index,ContainerStatus item) {
      this.index = index;
      this.builder = new ContainerStatusBuilder(this, item);
    }
    ContainerStatusesNestedImpl() {
      this.index = -1;
      this.builder = new ContainerStatusBuilder(this);
    }
    ContainerStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) RevisionStatusFluentImpl.this.setToContainerStatuses(index,builder.build());
    }
    public N endContainerStatus() {
      return and();
    }
    
  }
  
}