package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AwsSqsSourceBuilder extends AwsSqsSourceFluentImpl<AwsSqsSourceBuilder> implements VisitableBuilder<AwsSqsSource,AwsSqsSourceBuilder>{
  public AwsSqsSourceBuilder() {
    this(false);
  }
  public AwsSqsSourceBuilder(Boolean validationEnabled) {
    this(new AwsSqsSource(), validationEnabled);
  }
  public AwsSqsSourceBuilder(AwsSqsSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public AwsSqsSourceBuilder(AwsSqsSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AwsSqsSource(), validationEnabled);
  }
  public AwsSqsSourceBuilder(AwsSqsSourceFluent<?> fluent,AwsSqsSource instance) {
    this(fluent, instance, false);
  }
  public AwsSqsSourceBuilder(AwsSqsSourceFluent<?> fluent,AwsSqsSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public AwsSqsSourceBuilder(AwsSqsSource instance) {
    this(instance,false);
  }
  public AwsSqsSourceBuilder(AwsSqsSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  AwsSqsSourceFluent<?> fluent;
  Boolean validationEnabled;
  public AwsSqsSource build() {
    AwsSqsSource buildable = new AwsSqsSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}