package io.fabric8.knative.eventing.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import java.lang.Integer;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TriggerSpecFluentImpl<A extends TriggerSpecFluent<A>> extends BaseFluent<A> implements TriggerSpecFluent<A>{
  public TriggerSpecFluentImpl() {
  }
  public TriggerSpecFluentImpl(TriggerSpec instance) {
    this.withBroker(instance.getBroker()); 
    this.withDelivery(instance.getDelivery()); 
    this.withFilter(instance.getFilter()); 
    this.withFilters(instance.getFilters()); 
    this.withSubscriber(instance.getSubscriber()); 
  }
  private String broker;
  private DeliverySpecBuilder delivery;
  private TriggerFilterBuilder filter;
  private ArrayList<SubscriptionsAPIFilterBuilder> filters = new ArrayList<SubscriptionsAPIFilterBuilder>();
  private DestinationBuilder subscriber;
  public String getBroker() {
    return this.broker;
  }
  public A withBroker(String broker) {
    this.broker=broker; return (A) this;
  }
  public Boolean hasBroker() {
    return this.broker != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDelivery instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeliverySpec getDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  public DeliverySpec buildDelivery() {
    return this.delivery!=null ?this.delivery.build():null;
  }
  public A withDelivery(DeliverySpec delivery) {
    _visitables.get("delivery").remove(this.delivery);
    if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} else { this.delivery = null; _visitables.get("delivery").remove(this.delivery); } return (A) this;
  }
  public Boolean hasDelivery() {
    return this.delivery != null;
  }
  public TriggerSpecFluent.DeliveryNested<A> withNewDelivery() {
    return new TriggerSpecFluentImpl.DeliveryNestedImpl();
  }
  public TriggerSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
    return new TriggerSpecFluentImpl.DeliveryNestedImpl(item);
  }
  public TriggerSpecFluent.DeliveryNested<A> editDelivery() {
    return withNewDeliveryLike(getDelivery());
  }
  public TriggerSpecFluent.DeliveryNested<A> editOrNewDelivery() {
    return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
  }
  public TriggerSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
    return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFilter instead.
   * @return The buildable object.
   */
  @Deprecated
  public TriggerFilter getFilter() {
    return this.filter!=null ?this.filter.build():null;
  }
  public TriggerFilter buildFilter() {
    return this.filter!=null ?this.filter.build():null;
  }
  public A withFilter(TriggerFilter filter) {
    _visitables.get("filter").remove(this.filter);
    if (filter!=null){ this.filter= new TriggerFilterBuilder(filter); _visitables.get("filter").add(this.filter);} else { this.filter = null; _visitables.get("filter").remove(this.filter); } return (A) this;
  }
  public Boolean hasFilter() {
    return this.filter != null;
  }
  public TriggerSpecFluent.FilterNested<A> withNewFilter() {
    return new TriggerSpecFluentImpl.FilterNestedImpl();
  }
  public TriggerSpecFluent.FilterNested<A> withNewFilterLike(TriggerFilter item) {
    return new TriggerSpecFluentImpl.FilterNestedImpl(item);
  }
  public TriggerSpecFluent.FilterNested<A> editFilter() {
    return withNewFilterLike(getFilter());
  }
  public TriggerSpecFluent.FilterNested<A> editOrNewFilter() {
    return withNewFilterLike(getFilter() != null ? getFilter(): new TriggerFilterBuilder().build());
  }
  public TriggerSpecFluent.FilterNested<A> editOrNewFilterLike(TriggerFilter item) {
    return withNewFilterLike(getFilter() != null ? getFilter(): item);
  }
  public A addToFilters(Integer index,SubscriptionsAPIFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").add(index >= 0 ? index : _visitables.get("filters").size(), builder);this.filters.add(index >= 0 ? index : filters.size(), builder); return (A)this;
  }
  public A setToFilters(Integer index,SubscriptionsAPIFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
    if (index < 0 || index >= _visitables.get("filters").size()) { _visitables.get("filters").add(builder); } else { _visitables.get("filters").set(index, builder);}
    if (index < 0 || index >= filters.size()) { filters.add(builder); } else { filters.set(index, builder);}
     return (A)this;
  }
  public A addToFilters(io.fabric8.knative.eventing.v1.SubscriptionsAPIFilter... items) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A addAllToFilters(Collection<SubscriptionsAPIFilter> items) {
    if (this.filters == null) {this.filters = new ArrayList<SubscriptionsAPIFilterBuilder>();}
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A removeFromFilters(io.fabric8.knative.eventing.v1.SubscriptionsAPIFilter... items) {
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
  }
  public A removeAllFromFilters(Collection<SubscriptionsAPIFilter> items) {
    for (SubscriptionsAPIFilter item : items) {SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);_visitables.get("filters").remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromFilters(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
    if (filters == null) return (A) this;
    final Iterator<SubscriptionsAPIFilterBuilder> each = filters.iterator();
    final List visitables = _visitables.get("filters");
    while (each.hasNext()) {
      SubscriptionsAPIFilterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildFilters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SubscriptionsAPIFilter> getFilters() {
    return filters != null ? build(filters) : null;
  }
  public List<SubscriptionsAPIFilter> buildFilters() {
    return filters != null ? build(filters) : null;
  }
  public SubscriptionsAPIFilter buildFilter(Integer index) {
    return this.filters.get(index).build();
  }
  public SubscriptionsAPIFilter buildFirstFilter() {
    return this.filters.get(0).build();
  }
  public SubscriptionsAPIFilter buildLastFilter() {
    return this.filters.get(filters.size() - 1).build();
  }
  public SubscriptionsAPIFilter buildMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
    for (SubscriptionsAPIFilterBuilder item: filters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
    for (SubscriptionsAPIFilterBuilder item: filters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFilters(List<SubscriptionsAPIFilter> filters) {
    if (this.filters != null) { _visitables.get("filters").removeAll(this.filters);}
    if (filters != null) {this.filters = new ArrayList(); for (SubscriptionsAPIFilter item : filters){this.addToFilters(item);}} else { this.filters = null;} return (A) this;
  }
  public A withFilters(io.fabric8.knative.eventing.v1.SubscriptionsAPIFilter... filters) {
    if (this.filters != null) {this.filters.clear();}
    if (filters != null) {for (SubscriptionsAPIFilter item :filters){ this.addToFilters(item);}} return (A) this;
  }
  public Boolean hasFilters() {
    return filters != null && !filters.isEmpty();
  }
  public TriggerSpecFluent.FiltersNested<A> addNewFilter() {
    return new TriggerSpecFluentImpl.FiltersNestedImpl();
  }
  public TriggerSpecFluent.FiltersNested<A> addNewFilterLike(SubscriptionsAPIFilter item) {
    return new TriggerSpecFluentImpl.FiltersNestedImpl(-1, item);
  }
  public TriggerSpecFluent.FiltersNested<A> setNewFilterLike(Integer index,SubscriptionsAPIFilter item) {
    return new TriggerSpecFluentImpl.FiltersNestedImpl(index, item);
  }
  public TriggerSpecFluent.FiltersNested<A> editFilter(Integer index) {
    if (filters.size() <= index) throw new RuntimeException("Can't edit filters. Index exceeds size.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public TriggerSpecFluent.FiltersNested<A> editFirstFilter() {
    if (filters.size() == 0) throw new RuntimeException("Can't edit first filters. The list is empty.");
    return setNewFilterLike(0, buildFilter(0));
  }
  public TriggerSpecFluent.FiltersNested<A> editLastFilter() {
    int index = filters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last filters. The list is empty.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public TriggerSpecFluent.FiltersNested<A> editMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<filters.size();i++) { 
    if (predicate.test(filters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching filters. No match found.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSubscriber instead.
   * @return The buildable object.
   */
  @Deprecated
  public Destination getSubscriber() {
    return this.subscriber!=null ?this.subscriber.build():null;
  }
  public Destination buildSubscriber() {
    return this.subscriber!=null ?this.subscriber.build():null;
  }
  public A withSubscriber(Destination subscriber) {
    _visitables.get("subscriber").remove(this.subscriber);
    if (subscriber!=null){ this.subscriber= new DestinationBuilder(subscriber); _visitables.get("subscriber").add(this.subscriber);} else { this.subscriber = null; _visitables.get("subscriber").remove(this.subscriber); } return (A) this;
  }
  public Boolean hasSubscriber() {
    return this.subscriber != null;
  }
  public TriggerSpecFluent.SubscriberNested<A> withNewSubscriber() {
    return new TriggerSpecFluentImpl.SubscriberNestedImpl();
  }
  public TriggerSpecFluent.SubscriberNested<A> withNewSubscriberLike(Destination item) {
    return new TriggerSpecFluentImpl.SubscriberNestedImpl(item);
  }
  public TriggerSpecFluent.SubscriberNested<A> editSubscriber() {
    return withNewSubscriberLike(getSubscriber());
  }
  public TriggerSpecFluent.SubscriberNested<A> editOrNewSubscriber() {
    return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): new DestinationBuilder().build());
  }
  public TriggerSpecFluent.SubscriberNested<A> editOrNewSubscriberLike(Destination item) {
    return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TriggerSpecFluentImpl that = (TriggerSpecFluentImpl) o;
    if (broker != null ? !broker.equals(that.broker) :that.broker != null) return false;
    if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
    if (filter != null ? !filter.equals(that.filter) :that.filter != null) return false;
    if (filters != null ? !filters.equals(that.filters) :that.filters != null) return false;
    if (subscriber != null ? !subscriber.equals(that.subscriber) :that.subscriber != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(broker,  delivery,  filter,  filters,  subscriber,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (broker != null) { sb.append("broker:"); sb.append(broker + ","); }
    if (delivery != null) { sb.append("delivery:"); sb.append(delivery + ","); }
    if (filter != null) { sb.append("filter:"); sb.append(filter + ","); }
    if (filters != null && !filters.isEmpty()) { sb.append("filters:"); sb.append(filters + ","); }
    if (subscriber != null) { sb.append("subscriber:"); sb.append(subscriber); }
    sb.append("}");
    return sb.toString();
  }
  class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<TriggerSpecFluent.DeliveryNested<N>> implements TriggerSpecFluent.DeliveryNested<N>,Nested<N>{
    DeliveryNestedImpl(DeliverySpec item) {
      this.builder = new DeliverySpecBuilder(this, item);
    }
    DeliveryNestedImpl() {
      this.builder = new DeliverySpecBuilder(this);
    }
    DeliverySpecBuilder builder;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.withDelivery(builder.build());
    }
    public N endDelivery() {
      return and();
    }
    
  }
  class FilterNestedImpl<N> extends TriggerFilterFluentImpl<TriggerSpecFluent.FilterNested<N>> implements TriggerSpecFluent.FilterNested<N>,Nested<N>{
    FilterNestedImpl(TriggerFilter item) {
      this.builder = new TriggerFilterBuilder(this, item);
    }
    FilterNestedImpl() {
      this.builder = new TriggerFilterBuilder(this);
    }
    TriggerFilterBuilder builder;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.withFilter(builder.build());
    }
    public N endFilter() {
      return and();
    }
    
  }
  class FiltersNestedImpl<N> extends SubscriptionsAPIFilterFluentImpl<TriggerSpecFluent.FiltersNested<N>> implements TriggerSpecFluent.FiltersNested<N>,Nested<N>{
    FiltersNestedImpl(Integer index,SubscriptionsAPIFilter item) {
      this.index = index;
      this.builder = new SubscriptionsAPIFilterBuilder(this, item);
    }
    FiltersNestedImpl() {
      this.index = -1;
      this.builder = new SubscriptionsAPIFilterBuilder(this);
    }
    SubscriptionsAPIFilterBuilder builder;
    Integer index;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.setToFilters(index,builder.build());
    }
    public N endFilter() {
      return and();
    }
    
  }
  class SubscriberNestedImpl<N> extends DestinationFluentImpl<TriggerSpecFluent.SubscriberNested<N>> implements TriggerSpecFluent.SubscriberNested<N>,Nested<N>{
    SubscriberNestedImpl(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    SubscriberNestedImpl() {
      this.builder = new DestinationBuilder(this);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.withSubscriber(builder.build());
    }
    public N endSubscriber() {
      return and();
    }
    
  }
  
}