package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.PodOS;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodReadinessGate;
import io.fabric8.kubernetes.api.model.HostAlias;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.util.Map;

 /**
  * Generated
  */
public interface RevisionSpecFluent<A extends RevisionSpecFluent<A>> extends Fluent<A>{
  public Long getActiveDeadlineSeconds();
  public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
  public Boolean hasActiveDeadlineSeconds();
  public Affinity getAffinity();
  public A withAffinity(Affinity affinity);
  public Boolean hasAffinity();
  public Boolean getAutomountServiceAccountToken();
  public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken);
  public Boolean hasAutomountServiceAccountToken();
  public Long getContainerConcurrency();
  public A withContainerConcurrency(Long containerConcurrency);
  public Boolean hasContainerConcurrency();
  public A addToContainers(Integer index,Container item);
  public A setToContainers(Integer index,Container item);
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToContainers(Collection<Container> items);
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromContainers(Collection<Container> items);
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getContainers();
  public List<Container> buildContainers();
  public Container buildContainer(Integer index);
  public Container buildFirstContainer();
  public Container buildLastContainer();
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate);
  public A withContainers(List<Container> containers);
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers);
  public Boolean hasContainers();
  public RevisionSpecFluent.ContainersNested<A> addNewContainer();
  public RevisionSpecFluent.ContainersNested<A> addNewContainerLike(Container item);
  public RevisionSpecFluent.ContainersNested<A> setNewContainerLike(Integer index,Container item);
  public RevisionSpecFluent.ContainersNested<A> editContainer(Integer index);
  public RevisionSpecFluent.ContainersNested<A> editFirstContainer();
  public RevisionSpecFluent.ContainersNested<A> editLastContainer();
  public RevisionSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate);
  public PodDNSConfig getDnsConfig();
  public A withDnsConfig(PodDNSConfig dnsConfig);
  public Boolean hasDnsConfig();
  public String getDnsPolicy();
  public A withDnsPolicy(String dnsPolicy);
  public Boolean hasDnsPolicy();
  public Boolean getEnableServiceLinks();
  public A withEnableServiceLinks(Boolean enableServiceLinks);
  public Boolean hasEnableServiceLinks();
  public A addToEphemeralContainers(Integer index,EphemeralContainer item);
  public A setToEphemeralContainers(Integer index,EphemeralContainer item);
  public A addToEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items);
  public A addAllToEphemeralContainers(Collection<EphemeralContainer> items);
  public A removeFromEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items);
  public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items);
  public List<EphemeralContainer> getEphemeralContainers();
  public EphemeralContainer getEphemeralContainer(Integer index);
  public EphemeralContainer getFirstEphemeralContainer();
  public EphemeralContainer getLastEphemeralContainer();
  public EphemeralContainer getMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate);
  public Boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate);
  public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers);
  public A withEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... ephemeralContainers);
  public Boolean hasEphemeralContainers();
  public A addToHostAliases(Integer index,HostAlias item);
  public A setToHostAliases(Integer index,HostAlias item);
  public A addToHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items);
  public A addAllToHostAliases(Collection<HostAlias> items);
  public A removeFromHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items);
  public A removeAllFromHostAliases(Collection<HostAlias> items);
  public List<HostAlias> getHostAliases();
  public HostAlias getHostAlias(Integer index);
  public HostAlias getFirstHostAlias();
  public HostAlias getLastHostAlias();
  public HostAlias getMatchingHostAlias(Predicate<HostAlias> predicate);
  public Boolean hasMatchingHostAlias(Predicate<HostAlias> predicate);
  public A withHostAliases(List<HostAlias> hostAliases);
  public A withHostAliases(io.fabric8.kubernetes.api.model.HostAlias... hostAliases);
  public Boolean hasHostAliases();
  public Boolean getHostIPC();
  public A withHostIPC(Boolean hostIPC);
  public Boolean hasHostIPC();
  public Boolean getHostNetwork();
  public A withHostNetwork(Boolean hostNetwork);
  public Boolean hasHostNetwork();
  public Boolean getHostPID();
  public A withHostPID(Boolean hostPID);
  public Boolean hasHostPID();
  public String getHostname();
  public A withHostname(String hostname);
  public Boolean hasHostname();
  public Long getIdleTimeoutSeconds();
  public A withIdleTimeoutSeconds(Long idleTimeoutSeconds);
  public Boolean hasIdleTimeoutSeconds();
  public A addToImagePullSecrets(Integer index,LocalObjectReference item);
  public A setToImagePullSecrets(Integer index,LocalObjectReference item);
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets();
  public List<LocalObjectReference> buildImagePullSecrets();
  public LocalObjectReference buildImagePullSecret(Integer index);
  public LocalObjectReference buildFirstImagePullSecret();
  public LocalObjectReference buildLastImagePullSecret();
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets);
  public Boolean hasImagePullSecrets();
  public A addNewImagePullSecret(String name);
  public RevisionSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
  public RevisionSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
  public RevisionSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(Integer index,LocalObjectReference item);
  public RevisionSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(Integer index);
  public RevisionSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
  public RevisionSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
  public RevisionSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public A addToInitContainers(Integer index,Container item);
  public A setToInitContainers(Integer index,Container item);
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToInitContainers(Collection<Container> items);
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromInitContainers(Collection<Container> items);
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getInitContainers();
  public List<Container> buildInitContainers();
  public Container buildInitContainer(Integer index);
  public Container buildFirstInitContainer();
  public Container buildLastInitContainer();
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public A withInitContainers(List<Container> initContainers);
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers);
  public Boolean hasInitContainers();
  public RevisionSpecFluent.InitContainersNested<A> addNewInitContainer();
  public RevisionSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item);
  public RevisionSpecFluent.InitContainersNested<A> setNewInitContainerLike(Integer index,Container item);
  public RevisionSpecFluent.InitContainersNested<A> editInitContainer(Integer index);
  public RevisionSpecFluent.InitContainersNested<A> editFirstInitContainer();
  public RevisionSpecFluent.InitContainersNested<A> editLastInitContainer();
  public RevisionSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public String getNodeName();
  public A withNodeName(String nodeName);
  public Boolean hasNodeName();
  public A addToNodeSelector(String key,String value);
  public A addToNodeSelector(Map<String,String> map);
  public A removeFromNodeSelector(String key);
  public A removeFromNodeSelector(Map<String,String> map);
  public Map<String,String> getNodeSelector();
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector);
  public Boolean hasNodeSelector();
  public PodOS getOs();
  public A withOs(PodOS os);
  public Boolean hasOs();
  public A withNewOs(String name);
  public A addToOverhead(String key,Quantity value);
  public A addToOverhead(Map<String,Quantity> map);
  public A removeFromOverhead(String key);
  public A removeFromOverhead(Map<String,Quantity> map);
  public Map<String,Quantity> getOverhead();
  public <K,V>A withOverhead(Map<String,Quantity> overhead);
  public Boolean hasOverhead();
  public String getPreemptionPolicy();
  public A withPreemptionPolicy(String preemptionPolicy);
  public Boolean hasPreemptionPolicy();
  public Integer getPriority();
  public A withPriority(Integer priority);
  public Boolean hasPriority();
  public String getPriorityClassName();
  public A withPriorityClassName(String priorityClassName);
  public Boolean hasPriorityClassName();
  public A addToReadinessGates(Integer index,PodReadinessGate item);
  public A setToReadinessGates(Integer index,PodReadinessGate item);
  public A addToReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items);
  public A addAllToReadinessGates(Collection<PodReadinessGate> items);
  public A removeFromReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items);
  public A removeAllFromReadinessGates(Collection<PodReadinessGate> items);
  public List<PodReadinessGate> getReadinessGates();
  public PodReadinessGate getReadinessGate(Integer index);
  public PodReadinessGate getFirstReadinessGate();
  public PodReadinessGate getLastReadinessGate();
  public PodReadinessGate getMatchingReadinessGate(Predicate<PodReadinessGate> predicate);
  public Boolean hasMatchingReadinessGate(Predicate<PodReadinessGate> predicate);
  public A withReadinessGates(List<PodReadinessGate> readinessGates);
  public A withReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... readinessGates);
  public Boolean hasReadinessGates();
  public A addNewReadinessGate(String conditionType);
  public Long getResponseStartTimeoutSeconds();
  public A withResponseStartTimeoutSeconds(Long responseStartTimeoutSeconds);
  public Boolean hasResponseStartTimeoutSeconds();
  public String getRestartPolicy();
  public A withRestartPolicy(String restartPolicy);
  public Boolean hasRestartPolicy();
  public String getRuntimeClassName();
  public A withRuntimeClassName(String runtimeClassName);
  public Boolean hasRuntimeClassName();
  public String getSchedulerName();
  public A withSchedulerName(String schedulerName);
  public Boolean hasSchedulerName();
  public PodSecurityContext getSecurityContext();
  public A withSecurityContext(PodSecurityContext securityContext);
  public Boolean hasSecurityContext();
  public String getServiceAccount();
  public A withServiceAccount(String serviceAccount);
  public Boolean hasServiceAccount();
  public String getServiceAccountName();
  public A withServiceAccountName(String serviceAccountName);
  public Boolean hasServiceAccountName();
  public Boolean getSetHostnameAsFQDN();
  public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN);
  public Boolean hasSetHostnameAsFQDN();
  public Boolean getShareProcessNamespace();
  public A withShareProcessNamespace(Boolean shareProcessNamespace);
  public Boolean hasShareProcessNamespace();
  public String getSubdomain();
  public A withSubdomain(String subdomain);
  public Boolean hasSubdomain();
  public Long getTerminationGracePeriodSeconds();
  public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds);
  public Boolean hasTerminationGracePeriodSeconds();
  public Long getTimeoutSeconds();
  public A withTimeoutSeconds(Long timeoutSeconds);
  public Boolean hasTimeoutSeconds();
  public A addToTolerations(Integer index,Toleration item);
  public A setToTolerations(Integer index,Toleration item);
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A addAllToTolerations(Collection<Toleration> items);
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A removeAllFromTolerations(Collection<Toleration> items);
  public List<Toleration> getTolerations();
  public Toleration getToleration(Integer index);
  public Toleration getFirstToleration();
  public Toleration getLastToleration();
  public Toleration getMatchingToleration(Predicate<Toleration> predicate);
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate);
  public A withTolerations(List<Toleration> tolerations);
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations);
  public Boolean hasTolerations();
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
  public A addToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item);
  public A setToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item);
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public List<TopologySpreadConstraint> getTopologySpreadConstraints();
  public TopologySpreadConstraint getTopologySpreadConstraint(Integer index);
  public TopologySpreadConstraint getFirstTopologySpreadConstraint();
  public TopologySpreadConstraint getLastTopologySpreadConstraint();
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate);
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate);
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints);
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints);
  public Boolean hasTopologySpreadConstraints();
  public A addToVolumes(Integer index,Volume item);
  public A setToVolumes(Integer index,Volume item);
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A addAllToVolumes(Collection<Volume> items);
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A removeAllFromVolumes(Collection<Volume> items);
  public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Volume> getVolumes();
  public List<Volume> buildVolumes();
  public Volume buildVolume(Integer index);
  public Volume buildFirstVolume();
  public Volume buildLastVolume();
  public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate);
  public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate);
  public A withVolumes(List<Volume> volumes);
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes);
  public Boolean hasVolumes();
  public RevisionSpecFluent.VolumesNested<A> addNewVolume();
  public RevisionSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item);
  public RevisionSpecFluent.VolumesNested<A> setNewVolumeLike(Integer index,Volume item);
  public RevisionSpecFluent.VolumesNested<A> editVolume(Integer index);
  public RevisionSpecFluent.VolumesNested<A> editFirstVolume();
  public RevisionSpecFluent.VolumesNested<A> editLastVolume();
  public RevisionSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate);
  public A withAutomountServiceAccountToken();
  public A withEnableServiceLinks();
  public A withHostIPC();
  public A withHostNetwork();
  public A withHostPID();
  public A withSetHostnameAsFQDN();
  public A withShareProcessNamespace();
  public interface ContainersNested<N> extends Nested<N>,ContainerFluent<RevisionSpecFluent.ContainersNested<N>>{
    public N and();
    public N endContainer();
    
  }
  public interface ImagePullSecretsNested<N> extends Nested<N>,LocalObjectReferenceFluent<RevisionSpecFluent.ImagePullSecretsNested<N>>{
    public N and();
    public N endImagePullSecret();
    
  }
  public interface InitContainersNested<N> extends Nested<N>,ContainerFluent<RevisionSpecFluent.InitContainersNested<N>>{
    public N and();
    public N endInitContainer();
    
  }
  public interface VolumesNested<N> extends Nested<N>,VolumeFluent<RevisionSpecFluent.VolumesNested<N>>{
    public N and();
    public N endVolume();
    
  }
  
}