package io.fabric8.knative.sources.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApiServerSourceListBuilder extends ApiServerSourceListFluentImpl<ApiServerSourceListBuilder> implements VisitableBuilder<ApiServerSourceList,ApiServerSourceListBuilder>{
  public ApiServerSourceListBuilder() {
    this(false);
  }
  public ApiServerSourceListBuilder(Boolean validationEnabled) {
    this(new ApiServerSourceList(), validationEnabled);
  }
  public ApiServerSourceListBuilder(ApiServerSourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public ApiServerSourceListBuilder(ApiServerSourceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApiServerSourceList(), validationEnabled);
  }
  public ApiServerSourceListBuilder(ApiServerSourceListFluent<?> fluent,ApiServerSourceList instance) {
    this(fluent, instance, false);
  }
  public ApiServerSourceListBuilder(ApiServerSourceListFluent<?> fluent,ApiServerSourceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ApiServerSourceListBuilder(ApiServerSourceList instance) {
    this(instance,false);
  }
  public ApiServerSourceListBuilder(ApiServerSourceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  ApiServerSourceListFluent<?> fluent;
  Boolean validationEnabled;
  public ApiServerSourceList build() {
    ApiServerSourceList buildable = new ApiServerSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}