package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaSourceBuilder extends KafkaSourceFluent<KafkaSourceBuilder> implements VisitableBuilder<KafkaSource,KafkaSourceBuilder>{
  public KafkaSourceBuilder() {
    this(new KafkaSource());
  }
  
  public KafkaSourceBuilder(KafkaSourceFluent<?> fluent) {
    this(fluent, new KafkaSource());
  }
  
  public KafkaSourceBuilder(KafkaSourceFluent<?> fluent,KafkaSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaSourceBuilder(KafkaSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaSourceFluent<?> fluent;
  
  public KafkaSource build() {
    KafkaSource buildable = new KafkaSource(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}