package io.fabric8.knative.eventing.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BrokerStatusBuilder extends BrokerStatusFluent<BrokerStatusBuilder> implements VisitableBuilder<BrokerStatus,BrokerStatusBuilder>{
  public BrokerStatusBuilder() {
    this(new BrokerStatus());
  }
  
  public BrokerStatusBuilder(BrokerStatusFluent<?> fluent) {
    this(fluent, new BrokerStatus());
  }
  
  public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,BrokerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BrokerStatusBuilder(BrokerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BrokerStatusFluent<?> fluent;
  
  public BrokerStatus build() {
    BrokerStatus buildable = new BrokerStatus(fluent.buildAddress(),fluent.buildAddresses(),fluent.getAnnotations(),fluent.buildConditions(),fluent.getDeadLetterSinkCACerts(),fluent.getDeadLetterSinkUri(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}