package io.fabric8.knative.internal.networking.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IngressRuleFluent<A extends IngressRuleFluent<A>> extends BaseFluent<A>{
  public IngressRuleFluent() {
  }
  
  public IngressRuleFluent(IngressRule instance) {
    this.copyInstance(instance);
  }
  private List<String> hosts = new ArrayList<String>();
  private HTTPIngressRuleValueBuilder http;
  private String visibility;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IngressRule instance) {
    instance = (instance != null ? instance : new IngressRule());
    if (instance != null) {
          this.withHosts(instance.getHosts());
          this.withHttp(instance.getHttp());
          this.withVisibility(instance.getVisibility());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToHosts(int index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.add(index, item);
    return (A)this;
  }
  
  public A setToHosts(int index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.set(index, item); return (A)this;
  }
  
  public A addToHosts(java.lang.String... items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  
  public A addAllToHosts(Collection<String> items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  
  public A removeFromHosts(java.lang.String... items) {
    if (this.hosts == null) return (A)this;
    for (String item : items) { this.hosts.remove(item);} return (A)this;
  }
  
  public A removeAllFromHosts(Collection<String> items) {
    if (this.hosts == null) return (A)this;
    for (String item : items) { this.hosts.remove(item);} return (A)this;
  }
  
  public List<String> getHosts() {
    return this.hosts;
  }
  
  public String getHost(int index) {
    return this.hosts.get(index);
  }
  
  public String getFirstHost() {
    return this.hosts.get(0);
  }
  
  public String getLastHost() {
    return this.hosts.get(hosts.size() - 1);
  }
  
  public String getMatchingHost(Predicate<String> predicate) {
      for (String item : hosts) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingHost(Predicate<String> predicate) {
      for (String item : hosts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHosts(List<String> hosts) {
    if (hosts != null) {
        this.hosts = new ArrayList();
        for (String item : hosts) {
          this.addToHosts(item);
        }
    } else {
      this.hosts = null;
    }
    return (A) this;
  }
  
  public A withHosts(java.lang.String... hosts) {
    if (this.hosts != null) {
        this.hosts.clear();
        _visitables.remove("hosts");
    }
    if (hosts != null) {
      for (String item : hosts) {
        this.addToHosts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHosts() {
    return this.hosts != null && !this.hosts.isEmpty();
  }
  
  public HTTPIngressRuleValue buildHttp() {
    return this.http != null ? this.http.build() : null;
  }
  
  public A withHttp(HTTPIngressRuleValue http) {
    this._visitables.remove("http");
    if (http != null) {
        this.http = new HTTPIngressRuleValueBuilder(http);
        this._visitables.get("http").add(this.http);
    } else {
        this.http = null;
        this._visitables.get("http").remove(this.http);
    }
    return (A) this;
  }
  
  public boolean hasHttp() {
    return this.http != null;
  }
  
  public HttpNested<A> withNewHttp() {
    return new HttpNested(null);
  }
  
  public HttpNested<A> withNewHttpLike(HTTPIngressRuleValue item) {
    return new HttpNested(item);
  }
  
  public HttpNested<A> editHttp() {
    return withNewHttpLike(java.util.Optional.ofNullable(buildHttp()).orElse(null));
  }
  
  public HttpNested<A> editOrNewHttp() {
    return withNewHttpLike(java.util.Optional.ofNullable(buildHttp()).orElse(new HTTPIngressRuleValueBuilder().build()));
  }
  
  public HttpNested<A> editOrNewHttpLike(HTTPIngressRuleValue item) {
    return withNewHttpLike(java.util.Optional.ofNullable(buildHttp()).orElse(item));
  }
  
  public String getVisibility() {
    return this.visibility;
  }
  
  public A withVisibility(String visibility) {
    this.visibility = visibility;
    return (A) this;
  }
  
  public boolean hasVisibility() {
    return this.visibility != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressRuleFluent that = (IngressRuleFluent) o;
    if (!java.util.Objects.equals(hosts, that.hosts)) return false;
    if (!java.util.Objects.equals(http, that.http)) return false;
    if (!java.util.Objects.equals(visibility, that.visibility)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(hosts,  http,  visibility,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hosts != null && !hosts.isEmpty()) { sb.append("hosts:"); sb.append(hosts + ","); }
    if (http != null) { sb.append("http:"); sb.append(http + ","); }
    if (visibility != null) { sb.append("visibility:"); sb.append(visibility + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HttpNested<N> extends HTTPIngressRuleValueFluent<HttpNested<N>> implements Nested<N>{
    HttpNested(HTTPIngressRuleValue item) {
      this.builder = new HTTPIngressRuleValueBuilder(this, item);
    }
    HTTPIngressRuleValueBuilder builder;
    
    public N and() {
      return (N) IngressRuleFluent.this.withHttp(builder.build());
    }
    
    public N endHttp() {
      return and();
    }
    
  
  }

}