package io.fabric8.knative.internal.pkg.apis;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConditionBuilder extends ConditionFluent<ConditionBuilder> implements VisitableBuilder<Condition,ConditionBuilder>{
  public ConditionBuilder() {
    this(new Condition());
  }
  
  public ConditionBuilder(ConditionFluent<?> fluent) {
    this(fluent, new Condition());
  }
  
  public ConditionBuilder(ConditionFluent<?> fluent,Condition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConditionBuilder(Condition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConditionFluent<?> fluent;
  
  public Condition build() {
    Condition buildable = new Condition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getSeverity(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}