package io.fabric8.knative.internal.pkg.apis.duck.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BindingBuilder extends BindingFluent<BindingBuilder> implements VisitableBuilder<Binding,BindingBuilder>{
  public BindingBuilder() {
    this(new Binding());
  }
  
  public BindingBuilder(BindingFluent<?> fluent) {
    this(fluent, new Binding());
  }
  
  public BindingBuilder(BindingFluent<?> fluent,Binding instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BindingBuilder(Binding instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BindingFluent<?> fluent;
  
  public Binding build() {
    Binding buildable = new Binding(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}